% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estimateEM.R
\name{imputed_traits}
\alias{imputed_traits}
\alias{imputed_traits.PhyloEM}
\title{Ancestral State Reconstruction}
\usage{
imputed_traits(x, ...)

\method{imputed_traits}{PhyloEM}(x, trait = 1, save_all = FALSE,
  where = c("nodes", "tips"), what = c("imputed", "variances",
  "expectations"), method.selection = NULL, reconstructed_states = NULL,
  ...)
}
\arguments{
\item{x}{an object of class \code{\link{PhyloEM}}.}

\item{...}{further arguments to be passed on to
\code{\link{params_process.PhyloEM}}}

\item{trait}{an integer giving the trait to extract. Default to 1.}

\item{save_all}{if TRUE, arguments \code{where} and \code{what} are ignored, and
all the moments are kept for further extraction with the same function, precising
the argument \code{reconstructed_states}. Default to FALSE.}

\item{where}{either "nodes" for ancestral state reconstruction, or "tips" for
data imputation.}

\item{what}{the quantity to retrieve. Either the imputed traits (default), their
conditional variances, or the simple expectations under the selected process.}

\item{method.selection}{(optional) the method selection to be used.
One of "LINselect", "DDSE", "Djump". Default to "LINselect".}

\item{reconstructed_states}{if the reconstructed states have already been
computed (by a previous call of the function, with \code{save_all=TRUE}),
they can be passed on here (avoids multiple computaions of the E step).}
}
\value{
A matrix or array with the computed quantities.
}
\description{
\code{imputed_traits.PhyloEM} takes an object of class \code{\link{PhyloEM}},
and returns the imputed traits values, either at the internal nodes (ancestral
state reconstruction) or at the tips (data imputation)
}
\section{Methods (by class)}{
\itemize{
\item \code{PhyloEM}: \code{\link{PhyloEM}} object
}}

\seealso{
\code{\link{params_process.PhyloEM}}, \code{\link{PhyloEM}}
}
