% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/init_EM.R
\name{params_BM}
\alias{params_BM}
\title{Create an object \code{params_process} for a BM}
\usage{
params_BM(p = 1, variance = diag(1, p, p), random = FALSE,
  value.root = rep(0, p), exp.root = rep(0, p), var.root = diag(1, p, p),
  edges = NULL, values = matrix(0, p, length(edges)),
  relativeTimes = NULL, nbr_of_shifts = length(edges), phylo = NULL,
  sBM_variance = FALSE, ...)
}
\arguments{
\item{p}{the dimension (number of traits) of the parameters. Default to 1.}

\item{variance}{the variance (rate matrix) of the BM. Default to 
\code{diag(1, p, p)}.}

\item{random}{whether the root of the BM is random (TRUE) or fixed (FALSE).
Default to FALSE.}

\item{value.root}{if random=FALSE, the root value. Default to 0.}

\item{exp.root}{if random=TRUE, the root expectation. Default to 0.}

\item{var.root}{if random=TRUE, the root variance. Default to
\code{diag(1, p, p)}.}

\item{edges}{a vector of edges where the shifts occur. Default to NULL
(no shift).}

\item{values}{a matrix of shift values, with p lines and as many columns as
the number of shifts. Each column is the p values for one shift. Default to
\code{matrix(0, p, length(edges))}.}

\item{relativeTimes}{(unused) the relative position of the shift on the
branch, between 0 (begining of the branch) and 1 (end of the branch). Default
to 0.}

\item{nbr_of_shifts}{the number of shifts to use (randomly drawn). Use only
if \code{edges} is not specified. In that case, a phylogenetic tree must be
provided (to allow a random sampling of its edges).}

\item{phylo}{a phylogenetic tree of class \code{\link[ape]{phylo}}. Needed only if
the shifts edges are not specified, or if sBM_variance=TRUE. Default to NULL.
If sBM_variance=TRUE, it must have a specified value for the root branch
length (slot root.edge).}

\item{sBM_variance}{if the root is random, does it depend on the length of the
root edge ? (For equivalent purposes with a rescaled OU). Default to FALSE. If
TRUE, a phylogenetic tree with root edge length must be provided.}

\item{...}{unused.}
}
\value{
an object of class \code{params_process}.
}
\description{
\code{params_BM} creates a coherent object params_process from user 
provided values of the paramerters. Non specidied parameters are set to 
default values.
}
\seealso{
\code{\link{params_process}}, \code{\link{params_OU}}
}
