% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parsimonyNumber.R
\name{plot.equivalent_shifts}
\alias{plot.equivalent_shifts}
\title{Plot all the equivalent solutions.}
\usage{
\method{plot}{equivalent_shifts}(x, trait = 1, numbering = FALSE,
  colors_tips = NULL, nbr_col = 3, gray_scale = FALSE, ...)
}
\arguments{
\item{x}{an object of class \code{equivalent_shifts}, result of
function \code{\link{equivalent_shifts}}}

\item{trait}{(integer) the trait to be plotted, if multivariate. Default to 1.}

\item{numbering}{wheter to number the solutions. Default to FALSE.}

\item{colors_tips}{user-provided colors for the tips of the tree. A vector
vector with as many colors as there are tips. Will be automatically computed
if not provided.}

\item{nbr_col}{the number of columns on which to display the plot.
Default to 3.}

\item{gray_scale}{if TRUE, a gray scale is used instead of colors. Default to
FALSE.}

\item{...}{further arguments to be passed to \code{\link[ape]{plot.phylo}}.}
}
\value{
A plot of the equivalent shifts allocations.
}
\description{
\code{plot.equivalent_shifts} plots a representation of all the equivalent
shifts allocations, with a representation of the shifts and their values,
and a coloration of the branches in term of regimes.
}
\details{
This function uses function \code{\link[ape]{plot.phylo}} for the actual
plotting of the trees.
}
\seealso{
\code{\link{equivalent_shifts}}, \code{\link[ape]{plot.phylo}}
}
