% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model_selection.R
\name{model_selection}
\alias{model_selection}
\alias{model_selection.PhyloEM}
\title{Model Selection of a fitted object}
\usage{
model_selection(x, ...)

\method{model_selection}{PhyloEM}(x, method.selection = c("LINselect", "DDSE",
  "Djump"), C.BM1 = 0.1, C.BM2 = 2.5, C.LINselect = 1.1,
  independent = FALSE, ...)
}
\arguments{
\item{x}{a fitted \code{\link{PhyloEM}} object}

\item{...}{Further arguments to be passed to \code{\link{estimateEM}}, including
tolerance parameters for stopping criteria, maximal number of iterations, etc.}

\item{method.selection}{Method selection to be used. Several ones can be
used at the same time. One of "LINselect" for the Baraud Giraud Huet LINselect 
method; "DDSE" for the Slope Heuristic or "Djump" for the Jump Heuristic, last
two based the Birgé Massart method.}

\item{C.BM1}{Multiplying constant to be used for the BigeMassart1 method.
Need to be positive. Default to 0.1.}

\item{C.BM2}{Multiplying constant to be used for the BigeMassart2 method.
Default to 2.5.}

\item{C.LINselect}{Multiplying constant to be used for the LINselect method.
Need to be greater than 1. Default to 1.1.}

\item{independent}{Are the trait assumed to be independent from one another?
Default to FALSE. OU in a multivariate setting only works if TRUE.}
}
\value{
The same object, but with a slot corresponding to the model selection used. See
function \code{\link{params_process.PhyloEM}} to retrieve the selected parameters.
}
\description{
\code{model_selection} does the model selection on a fitted \code{\link{PhyloEM}} 
object, and returns the same fitted object.
}
\section{Methods (by class)}{
\itemize{
\item \code{PhyloEM}: \code{\link{PhyloEM}} object
}}

\seealso{
\code{\link{PhyloEM}}, \code{\link{params_process.PhyloEM}},
\code{\link{imputed_traits.PhyloEM}}
}
