% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plfit.R
\name{plfit}
\alias{plfit}
\title{PlackettLuce Wrapper for Model-based Recursive Partitioning}
\usage{
plfit(y, x = NULL, ref = 1, start = NULL, weights = NULL,
  offset = NULL, ..., estfun = FALSE, object = FALSE)
}
\arguments{
\item{y}{a \code{"\link{grouped_rankings}"} object giving the rankings to
model.}

\item{x}{unused.}

\item{ref}{an integer or character string specifying the reference item (for
which log worth will be set to zero). If \code{NULL} the sum of the log worth
parameters is set to zero.}

\item{start}{starting values for the worth parameters and the tie parameters.}

\item{weights}{an optional vector of weights for each ranking.}

\item{offset}{unused.}

\item{...}{additional arguments passed to \code{PlackettLuce}.}

\item{estfun}{logical. If \code{TRUE} the empirical estimating functions
(score/gradient contributions) are returned.}

\item{object}{logical. If \code{TRUE} the fitted model is returned.}
}
\value{
a list with elements
\item{coefficients}{ model coefficients. }
\item{objfun}{ the negative log-likelihood. }
\item{estfun}{ if \code{estfun} the empirical estimating functions. }
\item{object}{ if \code{object} the fitted model. }
}
\description{
This is a wrapper around \code{PlackettLuce} as required by
\code{\link[partykit]{mob}} for model-based recursive partitioning. It is
not intended for general use.
}
\examples{
# rankings
R <- matrix(c(1, 2, 0, 0,
              4, 1, 2, 3,
              2, 1, 1, 1,
              1, 2, 3, 0,
              2, 1, 1, 0,
              1, 0, 3, 2), nrow = 6, byrow = TRUE)
colnames(R) <- c("apple", "banana", "orange", "pear")

# group rankings into two groups
G <- grouped_rankings(R, rep(1:2, 3))

# plfit() gives the same results as PlackettLuce()
pl <- plfit(G)
pl$coefficients
-pl$objfun

mod <- PlackettLuce(R)
coef(mod)
logLik(mod)
}
\keyword{internal}
