% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/adjacency.R
\name{adjacency}
\alias{adjacency}
\title{Create an Adjacency Matrix for a set of Rankings}
\usage{
adjacency(object, weights = NULL, ...)
}
\arguments{
\item{object}{a \code{\link{rankings}} object, or an object that can be
coerced by \code{as.rankings}.}

\item{weights}{an optional vector of weights for the rankings.}

\item{...}{further arguments passed to/from methods.}
}
\value{
an N by N matrix, where N is the number of items that can be ranked.
}
\description{
Convert a set of rankings to an adjacency matrix summarising wins
and losses between pairs of items.
}
\details{
For a \code{"rankings"} object based on N items, the adjacency matrix is an
N by N matrix, with element (i, j) being the number of times item i wins over
item j. For example, in the ranking {1} > {3, 4} > {2}, item 1 wins over
items 2, 3, and 4, and items 3 and 4 win over item 2.

If \code{weights} is specified, the values in the adjacency matrix are the
weighted counts.
}
\examples{
X <- matrix(c(2, 1, 2, 1, 2,
              3, 2, 0, 0, 1,
              1, 0, 2, 2, 3), nrow = 3, byrow = TRUE)
X <- as.rankings(X)
adjacency(X)

adjacency(X, weights = c(1, 1, 2))

}
