% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fitted.R
\name{fitted.PlackettLuce}
\alias{fitted.PlackettLuce}
\alias{fitted.pltree}
\title{Fitted Probabilities for PlackettLuce Objects}
\usage{
\method{fitted}{PlackettLuce}(object, aggregate = TRUE, free = TRUE,
  ...)

\method{fitted}{pltree}(object, aggregate = TRUE, free = TRUE, ...)
}
\arguments{
\item{object}{an object as returned by
\code{\link{PlackettLuce}} or \code{\link{pltree}}.}

\item{aggregate}{logical; if \code{TRUE} observations of the same choice from
the same set of alternatives are aggregated.}

\item{free}{logical; if \code{TRUE} only free choices are included, i.e.
choices of one item from a set of one item are excluded.}

\item{...}{further arguments, currently ignored.}
}
\value{
A list with the following components
\item{choices}{The selected item(s).}
\item{alternatives}{The set of item(s) that the choice was made from.}
\item{ranking}{The ranking(s) including this choice.}
\item{n}{The weighted count of rankings including this
choice (equal to the ranking weight if \code{aggregate = FALSE}.}
\item{fitted}{The fitted probability of making this choice.}
If \code{object} was a \code{"pltree"} object, the list has an
additional element, \code{node}, specifying which node the ranking corresponds
to.
}
\description{
Fitted probabilities for all choice/alternative combinations in the data.
}
\examples{
R <- matrix(c(1, 2, 0, 0,
              4, 1, 2, 3,
              2, 1, 1, 1,
              1, 2, 3, 0,
              2, 1, 1, 0,
              1, 0, 3, 2), nrow = 6, byrow = TRUE)
colnames(R) <- c("apple", "banana", "orange", "pear")

mod <- PlackettLuce(R)
fit <- fitted(mod)
fit
}
\seealso{
\code{\link{choices}}
}
