% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions_1.1.10.R
\name{BuildCtrlErrorRate}
\alias{BuildCtrlErrorRate}
\title{function BuildCtrlErrorRate}
\usage{
BuildCtrlErrorRate(
  ctrl.dir = "Plasma ctrl/",
  bai.ext = ".bai",
  pos_ranges.file = NULL,
  hotspot.file = NULL,
  cov.min = 5000,
  force = FALSE,
  output.dir = ctrl.dir,
  n.trim = 0
)
}
\arguments{
\item{ctrl.dir, }{char, foldername containing the control files (default 'Plasma ctrl/'). The typical folder hierarchy will consist of 'Plasma ctrl/rBAM'}

\item{bai.ext, }{char, filename extension of the bai files (default '.bai')}

\item{pos_ranges.file, }{char, name of the Rdata file containing the three variables \code{pos_ind}, \code{pos_snp} and \code{pos_ranges} as build by the function \code{PrepareLibrary}. Default NULL, use the position_ranges.rda provided, used for our analysis.}

\item{hotspot.file, }{char, name of the text file containing a list of the genomic positions of the hotspots (default NULL, read the provide hotspot.txt, see \code{hotspot})}

\item{cov.min, }{integer, minimal coverture to take into account a position (default 5000)}

\item{force, }{boolean, (default FALSE) if TRUE force all computations to all files including already processed ones}

\item{output.dir, }{char, name of the folder to save results (default \code{ctrl.dir}).}

\item{n.trim, }{integer, number of base positions trimmed at the ends of each amplicon (default 8)}
}
\value{
the number of processed files
}
\description{
Compute the SNV Position-Error Rates and INDEL Position-Error Rates from control samples (available in the control directory \code{ctrl.dir}).
This function requires MAF files, that will be automatically generated if not present in the specified control folder.
SNV PER is computed as the sum in control samples of SNV background counts / sum in control samples of depths where SNV background counts = depth - major allele count.
INDEL PER is computed as sum in control samples of INDEL background counts / sum in control samples of depths where INDEL background counts = sum of insertion and deletion counts.
}
\examples{
\dontrun{
   ctrl.dir = system.file("extdata", "4test_only/ctrl/", package = "PlasmaMutationDetector2")
   if (substr(ctrl.dir,nchar(ctrl.dir),nchar(ctrl.dir))!='/')
     ctrl.dir = paste0(ctrl.dir,'/') # TO RUN UNDER WINDOWS
   BuildCtrlErrorRate(ctrl.dir,output.dir=paste0(tempdir(),'/'))
   }

}
\references{
\emph{Analysis of base-position error rate of next-generation sequencing to detect tumor mutations in circulating DNA} N. Pécuchet, Y. Rozenholc, E. Zonta, D. Pietraz, A. Didelot, P. Combe, L. Gibault, J-B. Bachet, V. Taly, E. Fabre, H. Blons and P. Laurent-Puig in \emph{Clinical Chemistry}

\emph{Novel hybridization- and tag-based error-corrected method for sensitive ctDNA mutation detection using ion semiconductor sequencing} Kjersti Tjensvoll, Morten Lapin, Bjørnar Gilje, Herish Garresori, Satu Oltedal, Rakel Brendsdal Forthun, Anders Molven, Yves Rozenholc and Oddmund Nordgård  in \emph{Scientific Reports}
}
\author{
N. Pécuchet, P. Laurent-Puig, O. Nordgård and Y. Rozenholc
}
