% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/call_MIXCR.R
\name{call_MIXCR}
\alias{call_MIXCR}
\title{Extracts information on the VDJRegion level using MiXCR. This function assumes the user can run an executable instance of MiXCR and is elgible to use MiXCR as determined by license agreements. The VDJRegion corresponds to the recombined heavy and light chain loci starting from framework region 1 (FR1) and extending to frame work region 4 (FR4). This can be useful for extracting full-length sequences ready to clone and further calculating somatic hypermutation occurances.}
\usage{
call_MIXCR(VDJ.per.clone, mixcr.directory, species)
}
\arguments{
\item{VDJ.per.clone}{The output from the VDJ_per_clone function. This object should have information regarding the contigs and clonotype_ids for each cell.}

\item{mixcr.directory}{The directory containing an executable version of MiXCR. This must be downloaded separately and is under a separate license.}

\item{species}{Either "mmu" for mouse or "hsa" for human. These use the default germline genes for both species contained in MIXCR.}
}
\value{
Returns a nested list containing VDJRegion information as determined by MIXCR. The outer list corresponds to the individual repertoires in the same structure as the input  VDJ.per.clone. The inner list corresponds to each clonal family, as determined by either the VDJ_clonotype function or the defaul nucleotide clonotyping produced by cellranger.Each element in the inner list corresponds to a dataframe containing repertoire information such as isotype, CDR sequences, mean number of UMIs. This output can be supplied to further package functions such as VDJ_extract_sequences and VDJ_GEX_integrate.
}
\description{
Extracts information on the VDJRegion level using MiXCR. This function assumes the user can run an executable instance of MiXCR and is elgible to use MiXCR as determined by license agreements. The VDJRegion corresponds to the recombined heavy and light chain loci starting from framework region 1 (FR1) and extending to frame work region 4 (FR4). This can be useful for extracting full-length sequences ready to clone and further calculating somatic hypermutation occurances.
}
\examples{
\dontrun{
call_MIXCR(VDJ.per.clone = VDJ.per.clone.output
,mixcr.directory = "~/Downloads/mixcr-3.0.12/mixcr",species = "mmu")
}
}
\seealso{
VDJ_extract_sequences
}
