% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GEX_lineage_trajectories.R
\name{GEX_lineage_trajectories}
\alias{GEX_lineage_trajectories}
\title{This is a function to infer single cell trajectories and identifying lineage structures on clustered cells. Using the slingshot library}
\usage{
GEX_lineage_trajectories(GEX, grouping, cluster.num)
}
\arguments{
\item{GEX}{GEX output of the VDJ_GEX_matrix function (VDJ_GEX_matrix[[2]]))}

\item{grouping}{Determine by which identifier to group by. E.g. 'group_id' or default 'seurat_clusters' which are automatically generated in the clustering process.}

\item{cluster.num}{A seurat cluster number for starting point of the lineage. Can be identified by using Seurat::DimPlot(VGM[[2]],group.by = "seurat_clusters"). Default is "0".}
}
\value{
Returns a list. Element [[1]] returns updated GEX object with the inferred pseudotime trajectories per lineage. [[2]] returns the UMAP with the grouped cells. [[3]] and [[4]] show the slingshot inferred trajectories in two different styles.
}
\description{
This is a function to infer single cell trajectories and identifying lineage structures on clustered cells. Using the slingshot library
}
\examples{
\donttest{
try({
lineage_trajectories <- GEX_lineage_trajectories(Platypus::small_vgm[[2]],
 grouping = 'group_id',
 cluster.num = "3")
})
}
}
