% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pp_similarity.R
\name{pp_similarity}
\alias{pp_similarity}
\title{Calculate the similarity between different portfolios}
\usage{
pp_similarity(D, id = NULL, method = "all", return_all = TRUE)
}
\arguments{
\item{D}{Data frame in a tidy format with the following columns: "Country", "Sector", "Year", "Instrument", "Target" and "covered". "covered" is a binary identificator of whether the portfolio space is covered by policy intervention (1) or not (0). The remaining columns identify the case. Notice that "Year" is a numeric value, while the remaining 4 case identifiers are factors.}

\item{id}{A list with up to two elements, namely "Country", and "Year" indicating the specific identification characteristics of the portfolio(s) that must be processed. Defaults to NULL to process all portfolios.}

\item{method}{A character vector containing the indices of similarity requested. Defaults to "all". The implemented indices of binary similarity are "jaccard" (), "}

\item{return_all}{Logical indicating whether all possible combinations (countries and years of origin and destination) must be returned or only when they are different. Defaults to TRUE.}
}
\value{
A tidy dataset containing the portfolio identificators (Country, Sector and Year) plus the similarity measures and their values.
}
\description{
Calculate similarity between portfolios.
}
\examples{
\dontrun{
data(P.education)
pp_similarity(P.education, id = list(Year = 2025))
}
}
