% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/blockfinal.R
\name{blockfinal}
\alias{blockfinal}
\title{Result function for optimization routines}
\usage{
blockfinal(fn, fmf, dmf, groupsize, ni, xt, x, a, model_switch, bpop, d, docc,
  sigma, poped.db, opt_xt = poped.db$settings$optsw[2],
  opt_a = poped.db$settings$optsw[4], opt_x = poped.db$settings$optsw[4],
  fmf_init = NULL, dmf_init = NULL, param_cvs_init = NULL,
  compute_inv = TRUE, out_file = NULL, trflag = TRUE,
  footer_flag = TRUE, ...)
}
\arguments{
\item{fn}{The file handle to write to.}

\item{fmf}{The initial value of the FIM. If set to zero then it is computed.}

\item{dmf}{The inital OFV. If set to zero then it is computed.}

\item{groupsize}{A vector of the numer of individuals in each group.}

\item{ni}{A vector of the number of samples in each group.}

\item{xt}{A matrix of sample times.  Each row is a vector of sample times for a group.}

\item{x}{A matrix for the discrete design variables.  Each row is a group.}

\item{a}{A matrix of covariates.  Each row is a group.}

\item{model_switch}{A matrix that is the same size as xt, specifying which model each sample belongs to.}

\item{bpop}{Matrix defining the fixed effects, per row (row number = parameter_number) we should have:
\itemize{
\item column 1 the type of the distribution for E-family designs (0 = Fixed, 1 = Normal, 2 = Uniform,
 3 = User Defined Distribution, 4 = lognormal and 5 = truncated normal)
\item column 2  defines the mean.
\item column 3 defines the variance of the distribution (or length of uniform distribution).
}
Can also just supply the parameter values as a vector \code{c()}}

\item{d}{Matrix defining the diagnonals of the IIV (same logic as for the fixed efects).
can also just supply the parameter values as a \code{c()}.}

\item{docc}{Matrix defining the IOV, the IOV variances and the IOV distribution}

\item{sigma}{Matrix defining the variances can covariances of the residual variability terms of the model.
can also just supply the diagnonal parameter values (variances) as a \code{c()}.}

\item{poped.db}{A PopED database.}

\item{opt_xt}{Should the sample times be optimized?}

\item{opt_a}{Should the continuous design variables be optimized?}

\item{opt_x}{Should the discrete design variables be optimized?}

\item{fmf_init}{Initial FIM.}

\item{dmf_init}{Initial OFV.}

\item{param_cvs_init}{The inital design parameter RSE values.}

\item{compute_inv}{should the inverse of the FIM be used to compute expected RSE values?  Often not needed
except for diagnostic purposes.}

\item{out_file}{Which file should the output be directed to?  A string, a file handle using
\code{\link{file}} or \code{""} will output to the screen.}

\item{trflag}{Should the optimization be output to the screen and to a file?}

\item{footer_flag}{Should the footer text be printed out?}

\item{...}{arguments passed to \code{\link{evaluate.fim}} and \code{\link{ofv_fim}}.}
}
\description{
Create some output to the screen and a text file that summarizes the problem you solved.
}
\examples{
## Warfarin example from software comparison in:
## Nyberg et al., "Methods and software tools for design evaluation 
##   for population pharmacokinetics-pharmacodynamics studies", 
##   Br. J. Clin. Pharm., 2014. 

## Optimization using an additive + proportional reidual error to 
##   avoid sample times at very low concentrations (time 0 or very late samoples).
library(PopED)

## find the parameters that are needed to define from the structural model
ff.PK.1.comp.oral.sd.CL

## -- parameter definition function 
## -- names match parameters in function ff
sfg <- function(x,a,bpop,b,bocc){
  parameters=c(CL=bpop[1]*exp(b[1]),
               V=bpop[2]*exp(b[2]),
               KA=bpop[3]*exp(b[3]),
               Favail=bpop[4],
               DOSE=a[1])
  return(parameters) 
}

## -- Define initial design  and design space
poped.db <- create.poped.database(ff_file="ff.PK.1.comp.oral.sd.CL",
                                  fg_file="sfg",
                                  fError_file="feps.add.prop",
                                  bpop=c(CL=0.15, V=8, KA=1.0, Favail=1), 
                                  notfixed_bpop=c(1,1,1,0),
                                  d=c(CL=0.07, V=0.02, KA=0.6), 
                                  sigma=c(0.01,0.25),
                                  groupsize=32,
                                  xt=c( 0.5,1,2,6,24,36,72,120),
                                  minxt=0,
                                  maxxt=120,
                                  a=70,
                                  mina=0,
                                  maxa=100)
# warfarin optimization model 


FIM <- evaluate.fim(poped.db) 
dmf <- det(FIM)


blockfinal(fn="",fmf=FIM,
           dmf=dmf,
           groupsize=poped.db$design$groupsize,
           ni=poped.db$design$ni,
           xt=poped.db$design$xt,
           x=poped.db$design$x,a=poped.db$design$a,
           model_switch=poped.db$design$model_switch,
           poped.db$parameters$param.pt.val$bpop,
           poped.db$parameters$param.pt.val$d,
           poped.db$parameters$docc,
           poped.db$parameters$param.pt.val$sigma,
           poped.db,
           opt_xt=TRUE,
           fmf_init=FIM,
           dmf_init=dmf,
           param_cvs_init=rbind(get_rse(FIM,poped.db,use_percent=FALSE)))


}
\seealso{
Other Helper: \code{\link{blockexp}};
  \code{\link{blockheader}}; \code{\link{blockopt}}
}

