% Generated by roxygen2 (4.0.1): do not edit by hand
\name{meucci.ranking}
\alias{meucci.ranking}
\title{Asset Ranking}
\usage{
meucci.ranking(R, p, order)
}
\arguments{
\item{R}{xts object of asset returns}

\item{p}{a vector of the prior probability values}

\item{order}{a vector of indexes of the relative ranking of expected asset
returns in ascending order. For example, \code{order = c(2, 3, 1, 4)} means
that the expected returns of \code{R[,2] < R[,3], < R[,1] < R[,4]}.}
}
\value{
The estimated moments based on ranking views
}
\description{
Express views on the relative expected asset returns as in A. Meucci,
"Fully Flexible Views: Theory and Practice" and compute the first
and second moments.
}
\note{
This function is based on the \code{ViewRanking} function written by
Ram Ahluwalia in the Meucci package.
}
\examples{
data(edhec)
R <- edhec[,1:4]
p <- rep(1 / nrow(R), nrow(R))
meucci.ranking(R, p, c(2, 3, 1, 4))
}
\references{
A. Meucci, "Fully Flexible Views: Theory and Practice" \url{http://www.symmys.com/node/158}
See Meucci script for "RankingInformation/ViewRanking.m"
}
\seealso{
\code{\link{meucci.moments}}
}

