/*
 * Decompiled with CFR 0.152.
 */
package org.openfast.template;

import java.io.InputStream;
import org.openfast.BitVectorReader;
import org.openfast.Context;
import org.openfast.FieldValue;
import org.openfast.IntegerValue;
import org.openfast.Message;
import org.openfast.QName;
import org.openfast.ScalarValue;
import org.openfast.error.FastConstants;
import org.openfast.error.FastException;
import org.openfast.template.Field;
import org.openfast.template.FieldSet;
import org.openfast.template.Group;
import org.openfast.template.Scalar;
import org.openfast.template.operator.Operator;
import org.openfast.template.type.Type;

public class MessageTemplate
extends Group
implements FieldSet {
    private static final long serialVersionUID = 1L;

    public MessageTemplate(QName name, Field[] fields) {
        super(name, MessageTemplate.addTemplateIdField(fields), false);
        this.updateTemplateReference(fields);
        this.fields[0].setMessageTemplate(this);
    }

    private void updateTemplateReference(Field[] fields) {
        int i = 0;
        while (i < fields.length) {
            fields[i].setMessageTemplate(this);
            ++i;
        }
    }

    public boolean usesPresenceMap() {
        return true;
    }

    public MessageTemplate(String name, Field[] fields) {
        this(new QName(name), fields);
    }

    private static Field[] addTemplateIdField(Field[] fields) {
        Field[] newFields = new Field[fields.length + 1];
        newFields[0] = new Scalar("templateId", Type.U32, Operator.COPY, ScalarValue.UNDEFINED, false);
        System.arraycopy(fields, 0, newFields, 1, fields.length);
        return newFields;
    }

    public Field getField(int index) {
        return this.fields[index];
    }

    public int getFieldCount() {
        return this.fields.length;
    }

    public byte[] encode(Message message, Context context) {
        if (!context.getTemplateRegistry().isRegistered(message.getTemplate())) {
            throw new FastException("Cannot encode message: The template " + message.getTemplate() + " has not been registered.", FastConstants.D9_TEMPLATE_NOT_REGISTERED);
        }
        message.setInteger(0, context.getTemplateId(message.getTemplate()));
        return super.encode(message, this, context);
    }

    public Message decode(InputStream in, int templateId, BitVectorReader presenceMapReader, Context context) {
        try {
            if (context.isTraceEnabled()) {
                context.getDecodeTrace().groupStart(this);
            }
            FieldValue[] fieldValues = super.decodeFieldValues(in, this, presenceMapReader, context);
            fieldValues[0] = new IntegerValue(templateId);
            Message message = new Message(this, fieldValues);
            if (context.isTraceEnabled()) {
                context.getDecodeTrace().groupEnd();
            }
            return message;
        }
        catch (FastException e) {
            throw new FastException("An error occurred while decoding " + this, e.getCode(), e);
        }
    }

    public Class getValueType() {
        return Message.class;
    }

    public String toString() {
        return this.name.getName();
    }

    public FieldValue createValue(String value) {
        return new Message(this);
    }

    public Field[] getFields() {
        return this.fields;
    }

    public Field[] getTemplateFields() {
        Field[] f = new Field[this.fields.length - 1];
        System.arraycopy(this.fields, 1, f, 0, this.fields.length - 1);
        return f;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || !(obj instanceof MessageTemplate)) {
            return false;
        }
        return this.equals((MessageTemplate)obj);
    }

    private boolean equals(MessageTemplate other) {
        if (!this.name.equals(other.name)) {
            return false;
        }
        if (this.fields.length != other.fields.length) {
            return false;
        }
        int i = 0;
        while (i < this.fields.length) {
            if (!this.fields[i].equals(other.fields[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public int hashCode() {
        int hashCode = this.name != null ? this.name.hashCode() : 0;
        int i = 0;
        while (i < this.fields.length) {
            hashCode += this.fields[i].hashCode();
            ++i;
        }
        return hashCode;
    }
}

