% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/risk_analysis.R
\name{create_regime_buckets}
\alias{create_regime_buckets}
\title{Convert Continuous Indicator to Discrete Regimes}
\usage{
create_regime_buckets(
  indicator,
  breakpoints,
  labels = NULL,
  use_percentiles = FALSE
)
}
\arguments{
\item{indicator}{Numeric vector or data frame with indicator values}

\item{breakpoints}{Numeric vector of breakpoints}

\item{labels}{Optional character vector of regime names}

\item{use_percentiles}{Use percentiles instead of fixed breakpoints (default: FALSE)}
}
\value{
Integer vector of regime classifications
}
\description{
Transforms continuous indicators into discrete regime categories.
}
\examples{
data("sample_prices_weekly")
momentum <- calc_momentum(sample_prices_weekly, lookback = 12)
selected <- filter_top_n(momentum, 10)
# Create VIX-like indicator from volatility
vol <- calc_rolling_volatility(sample_prices_weekly, lookback = 20)
vix_proxy <- vol$SPY * 100  # Scale to VIX-like values
regimes <- create_regime_buckets(vix_proxy, c(15, 25))
}
