% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filters.R
\name{filter_by_percentile}
\alias{filter_by_percentile}
\title{Filter by Percentile}
\usage{
filter_by_percentile(signal_df, percentile, type = c("top", "bottom"))
}
\arguments{
\item{signal_df}{DataFrame with signal values}

\item{percentile}{Percentile threshold (0-100)}

\item{type}{"top" for highest signals, "bottom" for lowest}
}
\value{
Binary selection matrix
}
\description{
Select securities in the top or bottom X percentile.
More intuitive than filter_top_n when universe size varies.
}
\examples{
data("sample_prices_weekly")
momentum <- calc_momentum(sample_prices_weekly, 12)
# Select top 20th percentile
top_20pct <- filter_by_percentile(momentum, 20, type = "top")
}
