% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ml.R
\name{ml_backtest_seq}
\alias{ml_backtest_seq}
\title{One-call backtest wrapper (sequence features)}
\usage{
ml_backtest_seq(
  features_list,
  labels,
  steps = 26L,
  horizon = 4L,
  fit_fn,
  predict_fn,
  schedule = list(is = 156L, oos = 4L, step = 4L),
  group = c("pooled", "per_symbol", "per_group"),
  group_map = NULL,
  normalize = c("none", "zscore", "minmax"),
  selection = list(top_k = 15L, max_per_group = NULL),
  weighting = list(method = "softmax", temperature = 12, floor = 0),
  caps = list(max_per_symbol = 0.1, max_per_group = NULL),
  prices,
  initial_capital = 1e+05,
  name = "SEQ backtest"
)
}
\arguments{
\item{features_list}{list of panels to be stacked over \code{steps} history.}

\item{labels}{future-return panel aligned to the features.}

\item{steps}{int; lookback length (e.g., 26).}

\item{horizon}{int; label horizon (e.g., 4).}

\item{fit_fn}{function \verb{(X, y) -> model} trained on in-sample stacked rows.}

\item{predict_fn}{function \verb{(model, Xnew) -> numeric} scores.}

\item{schedule}{list with elements \code{is}, \code{oos}, \code{step}.}

\item{group}{one of \code{"pooled"}, \code{"per_symbol"}, \code{"per_group"}.}

\item{group_map}{optional \code{data.frame(Symbol, Group)} if \code{group = "per_group"}.}

\item{normalize}{\code{"none"}, \code{"zscore"}, or \code{"minmax"} applied using IS data only.}

\item{selection}{list: \code{top_k}, \code{max_per_group} (optional).}

\item{weighting}{list: \code{method}, \code{temperature}, \code{floor}.}

\item{caps}{list: \code{max_per_symbol}, optionally \code{max_per_group}.}

\item{prices}{price panel used by the backtester (\code{Date} + symbols).}

\item{initial_capital}{starting capital.}

\item{name}{string for the backtest result.}
}
\value{
list: \code{scores}, \code{mask}, \code{weights}, \code{backtest}.
}
\description{
One-call backtest wrapper (sequence features)
}
\examples{
\donttest{
# as above, but with steps/horizon and normalize
}
}
