% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/weighting.R
\name{weight_equally}
\alias{weight_equally}
\title{Equal Weight Portfolio Construction}
\usage{
weight_equally(selected_df)
}
\arguments{
\item{selected_df}{Binary selection matrix (1 = selected, 0 = not)}
}
\value{
Data.table with equal weights for selected securities
}
\description{
Creates equal-weighted portfolio from selection matrix.
The simplest and often most robust weighting scheme.
}
\examples{
data("sample_prices_weekly")
momentum <- calc_momentum(sample_prices_weekly, lookback = 12)
selected <- filter_top_n(momentum, 10)
weights <- weight_equally(selected)
}
