// Title: Statistique de test C dans l'article 2 avec Alain ...
// Ref. (book or article): 

#include <R.h>
#include "Rmath.h"

extern "C" {

  typedef double optimfn(int n, double *par, void *ex);
  typedef void optimgr(int n, double *par, double *gr, void *ex);
  void lbfgsb(int n, int lmm, double *x, double *lower,
	      double *upper, int *nbd, double *Fmin, optimfn fn,
	      optimgr gr, int *fail, void *ex, double factr,
	      double pgtol, int *fncount, int *grcount,
	      int maxit, char *msg, int trace, int nREPORT);

  void myoptimgrC(int n, double *par, double *gr, void *ex) {
    double quantileestimC(int n, double *par, void *ex);
    double *parh;
    parh = new double[1];
    parh[0] = par[0] + 0.0000000001;
    gr[0] = (quantileestimC(1, parh, ex) - quantileestimC(1, par, ex)) / 0.0000000001;
    delete[] parh;
  }

  double quantileestimC(int n, double *par, void *ex) {
  // n should be 1, and par[0] is alpha, and ex[0] is nsize (sample size) and ex[1] is stat
    double res, factinterp, q1 = 0.0, q2 = 0.0;
    int i;
    int nsize = (int)(((double*)ex)[0]);

    // Computed with M = 10 ^ 7
    double coeff[100][9] = {{13.8181,-123.7919,611.9377,-1719.9500,2889.4363,-2984.8604,1861.6597,-643.8484,94.8880},
			    {2.0326,19.4129,-98.1738,199.7433,-234.0310,164.5543,-67.5925,14.5268,-1.1696},
			    {2.5985,20.3410,-121.3223,289.8822,-404.9315,348.0520,-181.3676,52.5203,-6.4590},
			    {3.8525,12.0324,-99.0119,265.3562,-410.8419,392.8737,-229.6886,75.3921,-10.6407},
			    {3.8502,14.8973,-117.5485,318.3562,-495.0815,472.2956,-273.8684,88.7690,-12.3366},
			    {7.0995,-18.0307,28.3037,-43.9215,54.9891,-50.4428,30.0005,-10.1391,1.4823},
			    {7.7040,-21.8272,37.1325,-48.2638,37.4652,-13.0944,-2.5678,3.6430,-0.8427},
			    {7.4791,-20.2145,36.8351,-67.0993,96.1070,-96.0410,60.2022,-21.0447,3.1318},
			    {7.9496,-22.9792,41.6439,-61.8795,63.8029,-43.8550,18.3954,-4.0487,0.3323},
			    {9.1080,-34.8451,95.8176,-202.4169,288.9823,-271.0477,158.8954,-52.6567,7.5308},
			    {9.3995,-37.4735,107.3610,-230.8298,330.8369,-308.7226,179.1724,-58.6483,8.2782},
			    {8.3146,-24.1596,41.9544,-57.5839,57.0133,-42.0510,21.8845,-7.0264,1.0330},
			    {7.9822,-20.9184,29.6600,-32.6774,28.0126,-23.1615,16.1310,-6.9120,1.2675},
			    {9.4636,-36.2519,97.3831,-197.7893,271.0526,-244.4905,138.0051,-44.0518,6.0682},
			    {10.0117,-41.7640,122.3720,-262.8921,377.1701,-354.6752,208.7474,-69.6110,10.0345},
			    {8.1050,-20.2091,20.4129,4.0257,-47.6749,67.5110,-47.5778,17.4521,-2.6476},
			    {7.0246,-7.4867,-41.9862,171.8779,-319.2761,339.1223,-212.0518,72.7460,-10.5685},
			    {10.1160,-41.6901,117.7330,-239.3838,321.7455,-282.2398,154.7339,-48.0821,6.4724},
			    {9.9502,-40.0765,112.1529,-230.4715,316.5015,-285.4669,161.4255,-51.8120,7.2052},
			    {8.5094,-23.7161,34.3985,-27.0475,-5.3646,31.3808,-28.8317,12.0909,-2.0071},
			    {8.6639,-25.8184,45.6752,-58.8747,47.9708,-23.8720,6.0283,-0.2174,-0.1404},
			    {9.0928,-31.0400,72.1933,-131.8214,168.1587,-146.3465,81.8615,-26.4195,3.7400},
			    {10.4220,-45.8248,142.2475,-315.2885,458.7414,-431.8255,252.1112,-82.9012,11.7393},
			    {9.8158,-38.1454,102.7333,-205.1315,275.0501,-242.7498,134.0708,-41.8469,5.6280},
			    {9.4670,-34.0020,80.9021,-140.8162,161.3985,-119.8487,54.4845,-13.5333,1.3758},
			    {8.2595,-20.8355,20.3378,13.5956,-77.6571,110.6954,-81.0379,30.9529,-4.8803},
			    {11.1866,-52.1228,163.0820,-348.7392,482.5392,-430.2612,238.0997,-74.3940,10.0424},
			    {9.5986,-35.5378,89.5198,-167.6292,211.6627,-177.6665,94.2760,-28.5531,3.7652},
			    {10.4664,-44.2758,127.2341,-258.7355,346.6839,-303.5275,166.4110,-51.8219,7.0034},
			    {8.8904,-27.8039,54.1474,-78.2327,75.0115,-47.9888,19.4508,-4.4901,0.4553},
			    {9.8758,-38.7954,104.3756,-202.2332,257.2592,-212.0359,108.0057,-30.7298,3.7203},
			    {10.5093,-46.0267,140.0051,-300.5863,423.4063,-387.6088,221.2097,-71.4378,9.9738},
			    {9.6859,-36.9726,97.3894,-189.3204,247.8192,-216.1364,119.8782,-38.2477,5.3509},
			    {10.3862,-44.9623,136.1915,-293.1567,415.3636,-383.3229,220.8410,-72.0653,10.1734},
			    {10.1097,-41.4841,117.0403,-234.8096,308.9053,-264.1528,140.6532,-42.3053,5.4934},
			    {8.5052,-23.8903,36.8702,-34.7034,7.8980,16.6835,-18.7391,8.1916,-1.3638},
			    {9.9889,-39.9812,109.9053,-217.4388,285.3304,-246.2223,133.6702,-41.3761,5.5779},
			    {8.7365,-25.0732,36.0522,-17.2760,-40.6888,81.9567,-66.5128,26.5161,-4.2547},
			    {9.1750,-31.3652,71.2605,-120.8780,138.4136,-106.7422,52.8468,-15.1909,1.9388},
			    {9.0846,-30.6928,69.5579,-119.9892,142.3356,-115.4846,60.7243,-18.5962,2.5198},
			    {9.2351,-31.8988,72.8581,-122.2167,136.0344,-100.0833,46.2805,-12.1128,1.3650},
			    {9.7921,-38.4842,105.2199,-209.0448,276.4912,-240.8446,131.8153,-41.0066,5.5309},
			    {7.9167,-19.4559,22.2769,-6.3863,-26.6599,43.7914,-32.3461,12.2713,-1.9322},
			    {8.3929,-25.0324,48.6690,-74.6539,81.4607,-64.7124,35.2844,-11.6757,1.7495},
			    {8.5024,-25.9177,49.9824,-69.0203,57.6838,-26.9406,4.3963,1.2430,-0.4412},
			    {8.1414,-22.6334,36.1599,-34.4847,3.0463,28.3380,-30.2882,13.5373,-2.3239},
			    {8.9222,-32.3246,85.4807,-171.2994,231.6590,-208.3650,118.4192,-38.4130,5.4187},
			    {8.5809,-28.4567,65.5388,-112.5777,126.3181,-91.4219,40.0604,-9.4085,0.8687},
			    {8.0648,-22.5617,37.7465,-41.3263,17.2914,10.9310,-17.6588,8.4842,-1.4652},
			    {8.5633,-28.6643,66.7270,-114.4235,126.7393,-89.6022,37.8934,-8.4353,0.7114},
			    {6.9546,-11.1293,-13.8353,89.3059,-184.2544,205.0359,-131.9495,46.2062,-6.8213},
			    {8.4596,-29.0798,74.2136,-145.7934,193.0423,-169.6278,93.6731,-29.3404,3.9717},
			    {6.9715,-13.1200,0.7501,43.1897,-103.6105,121.4824,-80.8976,29.1993,-4.4405},
			    {8.0308,-25.2619,57.7050,-103.4242,125.9826,-103.7922,54.7208,-16.6719,2.2398},
			    {8.5740,-31.6897,89.4427,-189.6687,267.8068,-248.5955,144.5274,-47.6749,6.8110},
			    {8.3898,-30.2127,83.7950,-175.9588,245.2015,-223.4942,126.8048,-40.5867,5.5989},
			    {7.9599,-25.6062,61.0519,-112.0958,136.6444,-109.9795,55.5211,-15.9579,2.0037},
			    {8.0437,-27.2184,70.7768,-141.7304,189.3211,-166.8506,92.1880,-28.9182,3.9317},
			    {9.5006,-42.6127,139.4290,-311.4746,444.7842,-406.9353,229.9776,-73.1389,10.0172},
			    {6.4901,-10.4662,-5.5736,49.8364,-100.3107,104.1900,-61.5957,19.5594,-2.5797},
			    {6.2327,-7.3213,-22.9482,103.7636,-200.9117,219.1931,-140.4190,49.2830,-7.3199},
			    {9.1310,-39.8479,129.9737,-293.3648,425.4639,-396.9971,229.5503,-74.8997,10.5496},
			    {7.8460,-26.4714,68.7364,-134.5017,172.2384,-143.9885,75.0324,-22.1806,2.8525},
			    {8.3300,-33.1114,104.5274,-237.4990,348.1042,-327.7714,190.3920,-62.1173,8.7126},
			    {8.0801,-30.2990,89.8703,-194.2001,270.9023,-243.2091,134.8090,-42.0292,5.6470},
			    {6.9222,-18.1307,35.4145,-60.0520,72.6955,-63.2979,36.7043,-12.6119,1.9305},
			    {7.0856,-19.1163,35.8483,-49.4402,35.9044,-5.8140,-11.4098,8.2952,-1.7762},
			    {7.7572,-26.9236,73.3177,-148.7410,196.5973,-169.0035,90.2326,-27.1947,3.5385},
			    {7.4198,-23.6376,59.1735,-114.3626,145.4837,-121.3874,63.0027,-18.4272,2.3183},
			    {7.1748,-22.3508,59.2930,-129.6323,191.8486,-187.6635,114.4562,-39.3633,5.8225},
			    {8.3081,-33.8782,107.6832,-239.9645,341.8093,-312.0830,175.8210,-55.7086,7.5994},
			    {6.5234,-14.3418,16.5331,-2.9407,-34.1828,60.8558,-50.2729,20.9615,-3.5463},
			    {7.4007,-25.3240,73.4438,-164.8614,243.9753,-235.2692,140.8540,-47.5395,6.9109},
			    {7.0590,-20.9839,48.7036,-87.4962,100.7134,-73.8003,32.0672,-7.2880,0.6222},
			    {6.1529,-11.2651,4.0512,26.0390,-73.6784,92.3412,-64.1516,23.7902,-3.6787},
			    {6.2769,-14.2681,23.6853,-36.3630,39.7603,-31.7791,16.8131,-5.2554,0.7351},
			    {6.0043,-11.0445,6.9175,12.2315,-45.2534,60.1497,-43.3012,16.5220,-2.6184},
			    {6.5155,-18.0565,46.0459,-105.4211,165.3256,-171.1592,109.8038,-39.5578,6.1147},
			    {6.7819,-20.3105,51.8739,-107.8537,150.3468,-139.2398,80.9009,-26.6969,3.8135},
			    {7.6337,-29.7159,94.0895,-210.1846,298.1434,-270.0793,150.4591,-47.0533,6.3276},
			    {6.0664,-13.0608,18.9367,-22.5126,14.0762,-2.5709,-2.9114,1.9687,-0.3690},
			    {6.6921,-20.1492,51.8936,-106.2740,142.7062,-125.4473,68.6278,-21.2959,2.8722},
			    {4.6150,3.0579,-57.6929,179.1740,-307.0624,315.0820,-194.1727,66.2562,-9.6295},
			    {6.1058,-12.5633,11.1563,11.2565,-57.7479,83.3396,-62.0529,23.9111,-3.7766},
			    {7.3352,-27.9899,90.9478,-212.4251,316.1368,-300.2108,174.9047,-57.0433,7.9765},
			    {6.1778,-14.2664,22.8125,-27.5841,15.5755,0.8466,-7.1447,3.9213,-0.7066},
			    {7.1386,-26.5542,87.1838,-210.7064,327.6558,-327.1960,201.4002,-69.6348,10.3460},
			    {5.9999,-13.9368,27.5778,-53.7972,75.6090,-73.8440,45.5672,-15.9457,2.4044},
			    {6.5887,-20.7628,60.1904,-139.1477,210.7528,-207.1569,125.8648,-43.0168,6.3231},
			    {6.2042,-16.0708,36.0371,-70.9227,95.1296,-86.5577,50.0591,-16.6807,2.4384},
			    {5.7759,-11.3268,13.4255,-10.8948,-1.8761,11.3701,-10.3934,4.2197,-0.6634},
			    {6.9387,-23.8851,71.1033,-158.2847,227.6478,-211.9385,122.3387,-39.9139,5.6312},
			    {6.0410,-14.1734,27.1130,-48.8264,63.3554,-59.1195,36.0898,-12.8499,2.0085},
			    {5.7973,-11.0049,9.4237,5.6869,-37.6274,56.0614,-43.0477,17.1657,-2.8154},
			    {5.2845,-4.4621,-25.1694,104.4427,-205.1507,230.1179,-151.7714,54.6341,-8.2849},
			    {6.3593,-18.4411,48.3466,-103.4986,145.0616,-132.4015,74.7541,-23.8205,3.2831},
			    {7.2819,-27.9626,90.0411,-205.1283,296.0613,-272.4377,153.9010,-48.7433,6.6305},
			    {6.6472,-21.3401,60.1229,-129.7527,180.7512,-162.6632,90.2037,-28.0710,3.7468},
			    {6.0078,-13.9893,24.7914,-36.5029,32.3634,-16.4728,2.9417,0.8371,-0.3303},
			    {6.7736,-24.1309,79.0746,-193.5606,303.4303,-303.6249,186.0617,-63.7039,9.3309}};


    int npoints[100] = {10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 55, 60, 65, 70, 75, 80, 85, 90, 95, 100, 110, 120, 130, 140, 150, 160, 170, 180, 190, 200, 225, 250, 275, 300, 325, 350, 375, 400, 425, 450, 475, 500, 600, 700, 800, 900, 1000, 1250, 1500, 1750, 2000, 2250, 2500, 2750, 3000, 3250, 3500, 3750, 4000, 4250, 4500, 4750, 5000, 6000, 7000, 8000, 9000, 10000, 20000};

    int i1, i2;
    if (nsize >= 20000) {
      i1 = 99;
      i2 = 100;
    } else if (nsize <= 10) {
      i1 = 1;
      i2 = 2;
    } else {
      for(i = 1; i <= 100; i++) {
	if (nsize <= npoints[i - 1]) break;
      }
      i2 = i;
      i1 = i2 - 1;
    }

    int n1 = npoints[i1 - 1];
    int n2 = npoints[i2 - 1];

    factinterp = (double)(nsize - n1) / (double)(n2 - n1);

    for (i = 1; i <= 9; i++) {
      q1 = q1 + coeff[i1 - 1][i - 1] * R_pow(R_pow(fabs(log(par[0])), 0.1629264), i - 1); // I replaced -log(par[0]) with fabs(log(par[0])) pour des raisons d'arrondis numériques
      q2 = q2 + coeff[i2 - 1][i - 1] * R_pow(R_pow(fabs(log(par[0])), 0.1629264), i - 1);
    }
    
    res = q2 * factinterp + q1 * (1.0 - factinterp);
    res = R_pow(res - ((double*)ex)[1], 2.0);
    
    return res;
  }


  void stat38(double *x, int *xlen, double *level, int *nblevel, char **name, int *getname, double *statistic, int *pvalcomp, double *pvalue, double *critvalL, double *critvalR, int *usecrit, int *alter, int *decision, double *paramstat, int *nbparamstat) {

// If the test statistic can only be in category 3 or 4 (see just below), INDICATE the following line accordingly. Else, leave it commented.
// 0: two.sided=bilateral, 1: less=unilateral, 2: greater=unilateral, 3: bilateral test that rejects H0 only for large values of the test statistic, 
// 4: bilateral test that rejects H0 only for small values of the test statistic
    if (alter[0] != 0 && alter[0] != 1 && alter[0] != 2) error("alter should be in {0,1,2}");

    int i, j=0, n=xlen[0];
    if (getname[0] == 1) {    
// Here, INDICATE the name of your statistic
      const char *nom = "$K_2$";
// Here, INDICATE the number of parameters of your statistic
      nbparamstat[0] = 0;
// Here, INDICATE the default values of the parameters:
      if (name[0][0] == '1') { // To prevent writing in a non declared address (because maybe paramstat has not be initialized with a sufficient length since the correct value of nbparamstat[0] may be unkown yet).

     }
// The following 7 lines should NOT be modified
      const char *space = " ";
      while (nom[j] != '\0') {
	name[j][0] = nom[j];
	j++;
      }
      for (i=j;i<50;i++) name[i][0] = space[0];
      return;
    }

    if (n>3) {
// Computation of the value of the test statistic
//    double qnorm(double p, double mean, double sd, int lower_tail, int log_p);
//    double pnorm5(double x, double mu, double sigma, int lower_tail, int log_p);
    double C = 0.0, tmp = 0.0;
    double gamma=0.577215664901533, xbar=0.0, sigchap2=0.0, statvalue;
    //    double Vn = ((1.5 * M_PI *M_PI - 14.0) * R_pow(2.0 - log(2.0) - gamma, -2.12) - 3.78 * R_pow((double)n, -0.733)) / ((double)n);

    for (i = 0; i < n; i++) xbar = xbar + x[i];
    xbar = xbar / (double)n;

    for (i = 0; i < n; i++) sigchap2 = sigchap2 + R_pow(x[i] - xbar, 2.0);
    sigchap2 = sigchap2 / (double)n;

    for (i = 0; i < n; i++) {
	tmp = R_pow(x[i] - xbar, 2.0) / sigchap2;
	if (tmp > 0) C = C + tmp * log(tmp);
    }

    C = C / (double)n; // This is kurtosis_APD

    statvalue = (C - (2.0 - log(2.0) - gamma)) / sqrt((1.5 * M_PI * M_PI - 14.0) / (double)n) ;

    statistic[0] = statvalue; // Here is the test statistic value

    if (pvalcomp[0] == 1) {
	// If possible, computation of the p-value.
	#include "pvalues/pvalue38.cpp"
    }

// We take the decision to reject or not to reject the null hypothesis H0
    for (i = 0; i < nblevel[0]; i++) {
      
	if (usecrit[0] == 1) { // We use the provided critical values
	  if (alter[0] == 0) { if (statistic[0] > critvalR[i] || statistic[0] < critvalL[i]) decision[i] = 1; else decision[i] = 0; // two-sided
	  } else if (alter[0] == 1) {  if (statistic[0] < critvalL[i]) decision[i] = 1; else decision[i] = 0;  // less
	    } else { if (alter[0] == 2) {  if (statistic[0] > critvalR[i]) decision[i] = 1; else decision[i] = 0; } } // greater
      } else {
	    if (pvalue[0] < level[i]) decision[i] = 1; else decision[i] = 0; // We use the p-value
      }
    }
    
// If applicable, we free the unused array of pointers

}

// We return
    return;
    
        
  }
  
}

