% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/OptPrInDT.R
\name{OptPrInDT}
\alias{OptPrInDT}
\title{Optimisation of undersampling percentages for classification}
\usage{
OptPrInDT(data,classname,ctestv=NA,N=99,plmax=0.09,psmax=0.9,
               distl=0.01,dists=0.1,conf.level=0.95,minsplit=NA,minbucket=NA,
               valdat=data)
}
\arguments{
\item{data}{Input data frame with class factor variable 'classname' and the\cr
influential variables, which need to be factors or numericals (transform logicals and character variables to factors)}

\item{classname}{Name of class variable (character)}

\item{ctestv}{Vector of character strings of forbidden split results;\cr
Example: ctestv <- rbind('variable1 == \{value1, value2\}','variable2 <= value3'), where
character strings specified in 'value1', 'value2' are not allowed as results of a splitting operation in variable 1 in a tree.\cr
For restrictions of the type 'variable <= xxx', all split results in a tree are excluded with 'variable <= yyy' and yyy <= xxx.\cr
Trees with split results specified in 'ctestv' are not accepted during optimization.\cr
A concrete example is: 'ctestv <- rbind('ETH == \{C2a, C1a\}','AGE <= 20')' for variables 'ETH' and 'AGE' and values 'C2a','C1a', and '20';\cr
If no restrictions exist, the default = NA is used.}

\item{N}{Number (> 7) of repetitions (integer)}

\item{plmax}{Maximal undersampling percentage of larger class (numerical, > 0 and <= 1);\cr
default = 0.09}

\item{psmax}{Maximal undersampling percentage of smaller class (numerical, > 0 and <= 1);\cr
default = 0.9}

\item{distl}{Distance to the next lower undersampling percentage of larger class (numerical, > 0 and < 1);\cr
default = 0.01}

\item{dists}{Distance to the next lower undersampling percentage of smaller class (numerical, > 0 and < 1);\cr
default = 0.1}

\item{conf.level}{(1 - significance level) in function \code{ctree} (numerical, > 0 and <= 1);\cr
default = 0.95}

\item{minsplit}{Minimum number of elements in a node to be splitted;\cr
default = 20}

\item{minbucket}{Minimum number of elements in a node;\cr
default = 7}

\item{valdat}{validation data; default = data}
}
\value{
\describe{
\item{besttree}{best tree on full sample}
\item{bestba}{balanced accuracy of best tree on full sample}
\item{percl}{undersampling percentage of large class of best tree on full sample}
\item{percs}{undersampling percentage of small class of best tree on full sample}
}
}
\description{
The function OptPrInDT applies an iterative technique for finding optimal undersampling percentages 
 'percl' for the larger class and 'percs' for the smaller class by a nested grid search for the use of the function PrInDT for
the relationship between the two-class factor variable 'classname' and all other factor and numerical variables
in the data frame 'data' by means of 'N' repetitions of undersampling. The optimization citerion is the balanced accuracy 
on the validation sample 'valdat' (default = full sample 'data'). The trees generated from undersampling can be restricted by not accepting trees 
including split results specified in the character strings of the vector 'ctestv'.\cr
The inputs plmax and psmax determine the maximal values of the percentages and the inputs distl and dists the
the distances to the next smaller percentage to be tried.\cr
The parameters 'conf.level', 'minsplit', and 'minbucket' can be used to control the size of the trees.\cr
}
\details{
See help("RePrInDT") and help("PrInDT") for further information.

Standard output can be produced by means of \code{print(name$besttree)} or just \code{name$besttree} as well as \code{plot(name$besttree)} where 'name' is the output data 
frame of the function.\cr
}
\examples{
datastrat <- PrInDT::data_zero
data <- na.omit(datastrat) # cleaned full data: no NAs
# interpretation restrictions (split exclusions)
ctestv <- rbind('ETH == {C2a, C1a}','MLU == {1, 3}') # split exclusions
# call of OptPrInDT
out <- OptPrInDT(data,"real",ctestv,N=24,conf.level=0.995) # unstratified
out # print best model and ensembles as well as all observations
plot(out)

}
