% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/foo.R
\name{control.profile}
\alias{control.profile}
\title{Auxliary function for controlling profile log-likelihood in the linear Gaussian model}
\usage{
control.profile(phi = NULL, rel.nugget = NULL, fixed.beta = NULL,
  fixed.sigma2 = NULL, fixed.phi = NULL, fixed.rel.nugget = NULL)
}
\arguments{
\item{phi}{a vector of the different values that should be used in the likelihood evalutation for the scale parameter \code{phi}, or \code{NULL} if a single value is provided either as first argument in \code{start.par} (for profile likelihood maximization) or as fixed value in \code{fixed.phi}; default is \code{NULL}.}

\item{rel.nugget}{a vector of the different values that should be used in the likelihood evalutation for the relative variance of the nugget effect \code{nu2}, or \code{NULL} if a single value is provided either in \code{start.par} (for profile likelihood maximization) or as fixed value in \code{fixed.nu2}; default is \code{NULL}.}

\item{fixed.beta}{a vector for the fixed values of the regression coefficients \code{beta}, or \code{NULL} if profile log-likelihood is to be performed; default is \code{NULL}.}

\item{fixed.sigma2}{value for the fixed variance of the Gaussian process \code{sigma2}, or \code{NULL} if profile log-likelihood is to be performed; default is \code{NULL}.}

\item{fixed.phi}{value for the fixed scale parameter \code{phi} in the Matern function, or \code{NULL} if profile log-likelihood is to be performed; default is \code{NULL}.}

\item{fixed.rel.nugget}{value for the fixed relative variance of the nugget effect; \code{fixed.rel.nugget=NULL} if profile log-likelihood is to be performed; default is \code{NULL}.}
}
\value{
A list with components named as the arguments.
}
\description{
Auxiliary function used by \code{\link{loglik.linear.model}}. This function defines whether the profile-loglikelihood should be computed or evaluation of the likelihood is required by keeping the other parameters fixed.
}
\seealso{
\code{\link{loglik.linear.model}}
}
\author{
Emanuele Giorgi \email{e.giorgi@lancaster.ac.uk}

Peter J. Diggle \email{p.diggle@lancaster.ac.uk}
}
