% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/f_Machine_Learning.R
\name{save_model}
\alias{save_model}
\title{Saving the machine learning model on the disk}
\usage{
save_model(model = list(), dir = "ML_model")
}
\arguments{
\item{model}{A list of 8 elements which identify the previously built machine learning model (the list is obtained via the \code{model_classification} function).}

\item{dir}{The name of the directory where the selected model should be saved. The directory with all necessary files will be created in the working directory.}
}
\value{
This function saves a list of ML model elements on the disk, i.e. the resulting 8 files are written into the new directory specified by \code{dir}. The list should be obtained previously using the \code{model_classification} function. After saving the model, it can be loaded at any time by using the \code{load_model} function.
}
\description{
This function saves a list of machine learning model elements on the disk, i.e. the resulting 8 files are written.
}
\examples{
#Setting a temporal directory as a working director
\dontrun{wd<-tempdir()}
\dontrun{setwd(wd)}
#Building the model
#Building the model
\donttest{my.grid=list(eta=c(0.01,0.02,0.05),subsample=c(0.5,0.8))}
\donttest{data_train<-dplyr::filter(dataCOICOP,dataCOICOP$time<=as.Date("2021-10-01"))}
\donttest{data_test<-dplyr::filter(dataCOICOP,dataCOICOP$time==as.Date("2021-11-01"))}
\donttest{ML<-model_classification(data_train,data_test,class="coicop6",grid=my.grid,
indicators=c("description","codeIN", "grammage"),key_words=c("uht"),rounds=60)}
#Saving the model
\dontrun{save_model(ML, dir="My_model")}
}
