% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bills_legislation_by_keyword.R
\name{bills_legislation_by_keyword}
\alias{bills_legislation_by_keyword}
\title{Search Bills: to search the title and full text of legislation by keyword to get the 20 most recent bills}
\usage{
bills_legislation_by_keyword(
  query_keyword,
  sort = c("date", "_score"),
  dir = c("desc", "asc"),
  page = 1,
  myAPI_Key
)
}
\arguments{
\item{query_keyword}{keyword or phrase to search the title and full text of legislation to get the 20 most recent bills}

\item{sort}{_score or date (default is date)}

\item{dir}{sort direction: asc or desc}

\item{page}{Results come in batches of 20. The page parameter specifies which one to retrieve.}

\item{myAPI_Key}{API key from Propublica To use the congress API, you must sign up for an API key.}
}
\value{
a list object with the return values about title and full text of legislation by keyword
}
\description{
Use this request to search the title and full text of legislation by keyword to get the 20 most recent bills.
Searches cover House and Senate bills from the 113th Congress through the current Congress (115th).
If multiple words are given (e.g. query = health care) the search is treated as multiple keywords using the OR operator.
Quoting the words (e.g. query = "health care") makes it a phrase search.
Search results can be sorted by date (the default) or by relevance, and in ascending or descending order.
}
\examples{
\dontrun{
bills_legislation_by_keyword(query_keyword = 'megahertz')
}
}
