% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_independent_expenditure_office_totals.R
\name{get_independent_expenditure_office_totals}
\alias{get_independent_expenditure_office_totals}
\title{Get Independent Expenditure Office Totals}
\usage{
get_independent_expenditure_office_totals(
  cycle = 2018,
  office = c("house", "senate", "president"),
  page = 1,
  myAPI_Key
)
}
\arguments{
\item{cycle}{The election cycle}

\item{office}{one of house, senate or president}

\item{page}{Results come in batches of 20. The page parameter specifies which one to retrieve.}

\item{myAPI_Key}{API key from Propublica To use the congress API, you must sign up for an API key.}
}
\value{
List of returned JSON from endpoint that retrieves he amount of money spent in independent expenditures for a given office (either House, Senate or President).
}
\description{
HTTP Request: GET https://api.propublica.org/campaign-finance/v1/{cycle}/independent_expenditures/race_totals/{office}
}
\examples{
\dontrun{
get_independent_expenditure_office_totals(2016, 'president')
get_independent_expenditure_office_totals(2016, 'house')
get_independent_expenditure_office_totals(2016, 'senate')
}
}
