% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_recent_late_contributions_date.R
\name{get_recent_late_contributions_date}
\alias{get_recent_late_contributions_date}
\title{Get Recent Late Contributions by Date}
\usage{
get_recent_late_contributions_date(
  cycle = 2018,
  year,
  month,
  day,
  page = 1,
  myAPI_Key
)
}
\arguments{
\item{cycle}{The election cycle}

\item{year}{The four-digit year from 2010-2018, match cycle}

\item{month}{The two-digit month from 01-12}

\item{day}{The two-digit day from 01-31}

\item{page}{Results come in batches of 20. The page parameter specifies which one to retrieve.}

\item{myAPI_Key}{API key from Propublica To use the congress API, you must sign up for an API key.}
}
\value{
List of returned JSON from endpoint that retrieves late contributions from a specific dates for a given campaign cycle from the campaign-finance API from ProPublica.
}
\description{
HTTP Request: GET https://api.propublica.org/campaign-finance/v1/{cycle}/contributions/48hour/{year}/{month}/{day}
}
\examples{
\dontrun{
get_recent_late_contributions_date(2016, year = 2016, month = '09', day = '07')
}
}
