% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pro.sgpv.R
\name{summary.sgpv}
\alias{summary.sgpv}
\title{Summary of the OLS model on selected variables}
\usage{
\method{summary}{sgpv}(object, ...)
}
\arguments{
\item{object}{An \code{sgpv} object}

\item{...}{Other arguments}
}
\value{
Summary of an OLS model
}
\description{
S3 method \code{summary} for an S3 object of class \code{sgpv}
}
\examples{

# load the package
library(ProSGPV)

# prepare the data
x <- t.housing[, -ncol(t.housing)]
y <- t.housing$V9

# run one-stage algorithm
out.sgpv.1 <- pro.sgpv(x = x, y = y, stage = 1)

# get regression summary
summary(out.sgpv.1)
}
