% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/06PTModule.r
\docType{methods}
\name{clearSamples}
\alias{clearSamples}
\alias{clearSamples,PTModule-method}
\title{Clear all samples from module}
\usage{
\S4method{clearSamples}{PTModule}(mod)
}
\arguments{
\item{mod}{A \code{\link{PTModule}} object from which all samples needs
to be removed.}
}
\value{
Returns a copy of of object \code{mod} in which all samples are removed.
}
\description{
Remove all \code{\link{PTSample}}s from a \code{\link{PTModule}} object.
}
\details{
Conform the original ProTracker, this method removes all patterns
\code{\link{PTSample}}s from a module. You keep all patterns
(\code{\link{PTPattern}}) and \code{\link{patternOrder}} info.
}
\examples{
data(mod.intro)

## 'clear.mod' is a copy of 'mod.intro' without the
## samples. It still holds all pattern tables and
## pattern order info.
clear.mod <- clearSamples(mod.intro)
}
\author{
Pepijn de Vries
}
\seealso{
Other module.operations: \code{\link{PTModule}},
  \code{\link{PTModule-class}};
  \code{\link{appendPattern}},
  \code{\link{appendPattern,PTModule,PTPattern-method}};
  \code{\link{clearSong}},
  \code{\link{clearSong,PTModule-method}};
  \code{\link{deletePattern}},
  \code{\link{deletePattern,PTModule,numeric-method}};
  \code{\link{modToWave}},
  \code{\link{modToWave,PTModule-method}};
  \code{\link{moduleSize}},
  \code{\link{moduleSize,PTModule-method}};
  \code{\link{patternLength}},
  \code{\link{patternLength,PTModule-method}};
  \code{\link{patternOrderLength}},
  \code{\link{patternOrderLength,PTModule-method}},
  \code{\link{patternOrderLength<-}},
  \code{\link{patternOrderLength<-,PTModule,numeric-method}};
  \code{\link{patternOrder}},
  \code{\link{patternOrder,PTModule-method}},
  \code{\link{patternOrder<-}},
  \code{\link{patternOrder<-,PTModule,ANY,numeric-method}};
  \code{\link{playMod}},
  \code{\link{playMod,PTModule-method}};
  \code{\link{playingtable}},
  \code{\link{playingtable,PTModule-method}};
  \code{\link{read.module}},
  \code{\link{read.module,ANY-method}},
  \code{\link{read.module,character-method}};
  \code{\link{trackerFlag}},
  \code{\link{trackerFlag,PTModule-method}},
  \code{\link{trackerFlag<-}},
  \code{\link{trackerFlag<-,PTModule-method}};
  \code{\link{write.module}},
  \code{\link{write.module,PTModule,ANY-method}},
  \code{\link{write.module,PTModule,character-method}}
}

