% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/05PTSample.r
\docType{methods}
\name{loopStart}
\alias{loopStart}
\alias{loopStart,PTSample-method}
\alias{loopStart<-}
\alias{loopStart<-,PTSample-method}
\title{The loop start position of a PTSample}
\usage{
\S4method{loopStart}{PTSample}(sample)

\S4method{loopStart}{PTSample}(sample) <- value
}
\arguments{
\item{sample}{A \code{\link{PTSample}} for which the loop start position
needs to be extracted or replace.}

\item{value}{An even \code{numeric} value giving the loop starting position in
samples ranging from 0 up to 131070. The sum of the \code{\link{loopStart}} and
\code{\link{loopLength}} should not exceed the \code{\link{sampleLength}}.

Use a \code{value} of either \code{character} "\code{off}" or \code{logical}
"\code{FALSE}", in order to turn off the loop all together.}
}
\value{
For \code{loopStart} the loop start position (in samples), represented by
an even \code{integer} value ranging from 0 up to 131070, is returned.

For \code{loopStart<-} A \code{\link{PTSample}} \code{sample}, updated
with the loop start position `\code{value}', is returned.
}
\description{
Extract or replace the loop start position of a \code{\link{PTSample}}.
}
\details{
\code{\link{PTSample}}s can have loops, marked by a starting position
and length of the loop (in samples), for more details see the
\code{\link{PTSample-class}}. This method can be used to extract
the loop starting position or safely replace its value.
}
\examples{
data("mod.intro")

## get the loop start position of the
## first sample of mod.intro:

loopStart(PTSample(mod.intro, 1))

## Let's change the starting position of
## the loop to 500

loopStart(PTSample(mod.intro, 1)) <- 500

## Let's turn off the loop all together:

loopStart(PTSample(mod.intro, 1)) <- FALSE
}
\author{
Pepijn de Vries
}
\seealso{
Other loop.methods: \code{\link{loopLength}},
  \code{\link{loopLength,PTSample-method}},
  \code{\link{loopLength<-}},
  \code{\link{loopLength<-,PTSample-method}};
  \code{\link{loopSample}},
  \code{\link{loopSample,PTSample-method}};
  \code{\link{loopState}},
  \code{\link{loopState,PTSample-method}}

Other sample.operations: \code{\link{PTSample,PTModule,numeric-method}},
  \code{\link{PTSample,Wave,missing-method}},
  \code{\link{PTSample,raw,missing-method}},
  \code{\link{PTSample-method}}, \code{\link{PTSample<-}},
  \code{\link{PTSample<-,PTModule,numeric,PTSample-method}};
  \code{\link{PTSample}}, \code{\link{PTSample-class}};
  \code{\link{fineTune}},
  \code{\link{fineTune,PTSample-method}},
  \code{\link{fineTune<-}},
  \code{\link{fineTune<-,PTSample,numeric-method}};
  \code{\link{loopLength}},
  \code{\link{loopLength,PTSample-method}},
  \code{\link{loopLength<-}},
  \code{\link{loopLength<-,PTSample-method}};
  \code{\link{loopSample}},
  \code{\link{loopSample,PTSample-method}};
  \code{\link{loopState}},
  \code{\link{loopState,PTSample-method}};
  \code{\link{name}}, \code{\link{name,PTModule-method}},
  \code{\link{name,PTSample-method}}, \code{\link{name<-}},
  \code{\link{name<-,PTModule,character-method}},
  \code{\link{name<-,PTSample,character-method}};
  \code{\link{playSample}},
  \code{\link{playSample,PTModule-method}},
  \code{\link{playSample,PTSample-method}};
  \code{\link{read.sample}},
  \code{\link{read.sample,character-method}};
  \code{\link{sampleLength}},
  \code{\link{sampleLength,PTSample-method}};
  \code{\link{volume}},
  \code{\link{volume,PTSample-method}},
  \code{\link{volume<-}},
  \code{\link{volume<-,PTSample,numeric-method}};
  \code{\link{waveform}},
  \code{\link{waveform,PTSample-method}},
  \code{\link{waveform<-}},
  \code{\link{waveform<-,PTSample-method}};
  \code{\link{write.sample}},
  \code{\link{write.sample,PTSample,character-method}}
}

