% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/05PTSample.r, R/06PTModule.r
\docType{methods}
\name{name}
\alias{name}
\alias{name,PTModule-method}
\alias{name,PTSample-method}
\alias{name<-}
\alias{name<-,PTModule,character-method}
\alias{name<-,PTSample,character-method}
\title{Obtain or replace the name of a PTModule or PTSample}
\usage{
\S4method{name}{PTSample}(x)

\S4method{name}{PTSample,character}(x) <- value

\S4method{name}{PTModule}(x)

\S4method{name}{PTModule,character}(x) <- value
}
\arguments{
\item{x}{A \code{\link{PTModule}} or a \code{\link{PTSample}}
object for which to obtain or replace the name.}

\item{value}{A \code{character} string which should be used to replace the
name of \code{\link{PTModule}} or \code{\link{PTSample}} \code{x}.}
}
\value{
For \code{name}, the name of the \code{\link{PTModule}} or
\code{\link{PTSample}} object as a \code{character} string is returned.

For \code{name<-}, object \code{x} with an updated name is returned.
}
\description{
The name of both a \code{\link{PTModule}} and
\code{\link{PTSample}} are stored as \code{raw} data.
This method returns the name as a \code{character} string, or it can
be used to assign a new name to a \code{\link{PTModule}} or
\code{\link{PTSample}}.
}
\details{
The name of a \code{\link{PTModule}} and
\code{\link{PTSample}} is stored as a \code{vector} of
\code{raw} data with a length of 20 or 22 respectively. This method
provides the means for getting the name as a \code{character} string
or to safely redefine the name of a \code{\link{PTModule}} or
\code{\link{PTSample}} object. To do so,
the provided name (\code{value}) is converted to a \code{raw} \code{vector}
of length 20 or 22 respectively. Long names may therefore get clipped.
}
\examples{
data("mod.intro")

## get the name of mod.intro:
name(mod.intro)

## I don't like the name, let's change it:
name(mod.intro) <- "I like this name better"

## Note that the provided name was too long and is truncated:
name(mod.intro)

## print all sample names in the module:
unlist(lapply(as.list(1:31), function(x)
  name(PTSample(mod.intro, x))))
}
\author{
Pepijn de Vries
}
\seealso{
Other character.operations: \code{\link{as.character}},
  \code{\link{as.character,PTCell-method}},
  \code{\link{as.character,PTPattern-method}},
  \code{\link{as.character,PTTrack-method}};
  \code{\link{noteToSampleRate}},
  \code{\link{periodToSampleRate}},
  \code{\link{periodToSampleRate}},
  \code{\link{sampleRate}}, \code{\link{sampleRate}};
  \code{\link{periodToChar}}; \code{\link{rawToCharNull}}

Other sample.operations: \code{\link{PTSample,PTModule,numeric-method}},
  \code{\link{PTSample,Wave,missing-method}},
  \code{\link{PTSample,raw,missing-method}},
  \code{\link{PTSample-method}}, \code{\link{PTSample<-}},
  \code{\link{PTSample<-,PTModule,numeric,PTSample-method}};
  \code{\link{PTSample}}, \code{\link{PTSample-class}};
  \code{\link{fineTune}},
  \code{\link{fineTune,PTSample-method}},
  \code{\link{fineTune<-}},
  \code{\link{fineTune<-,PTSample,numeric-method}};
  \code{\link{loopLength}},
  \code{\link{loopLength,PTSample-method}},
  \code{\link{loopLength<-}},
  \code{\link{loopLength<-,PTSample-method}};
  \code{\link{loopSample}},
  \code{\link{loopSample,PTSample-method}};
  \code{\link{loopStart}},
  \code{\link{loopStart,PTSample-method}},
  \code{\link{loopStart<-}},
  \code{\link{loopStart<-,PTSample-method}};
  \code{\link{loopState}},
  \code{\link{loopState,PTSample-method}};
  \code{\link{playSample}},
  \code{\link{playSample,PTModule-method}},
  \code{\link{playSample,PTSample-method}};
  \code{\link{read.sample}},
  \code{\link{read.sample,character-method}};
  \code{\link{sampleLength}},
  \code{\link{sampleLength,PTSample-method}};
  \code{\link{volume}},
  \code{\link{volume,PTSample-method}},
  \code{\link{volume<-}},
  \code{\link{volume<-,PTSample,numeric-method}};
  \code{\link{waveform}},
  \code{\link{waveform,PTSample-method}},
  \code{\link{waveform<-}},
  \code{\link{waveform<-,PTSample-method}};
  \code{\link{write.sample}},
  \code{\link{write.sample,PTSample,character-method}}
}

