% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/01supporting_functions.r
\name{proTrackerVibrato}
\alias{proTrackerVibrato}
\title{Get the vibrato table used by ProTracker}
\usage{
proTrackerVibrato(x)
}
\arguments{
\item{x}{\code{integer} representing the table index ranging from 0
up to 31. Values outside this range can be used, but will produce
results that are not valid in the context of ProTracker.}
}
\value{
Returns an \code{integer} sine value ranging from 0 up to 255
when a valid table index (\code{x}) is provided. It will otherwise return
a sine value ranging from -255 up to 255.
}
\description{
Gets the vibrato table as used by ProTracker in vibrato effects.
}
\details{
As the old Commodore Amiga computer didn't have built-in mathematical functions,
many programs on that machine used their own data tables. As did ProTracker
for vibrato effects for which a sine function was used. As there was no sine
function that could be called, sine values were stored in a table.

This function returns the \code{integer} sine values (ranging from 0 up
to 255) as a function of the table index (ranging from 0 up to 31).
}
\examples{
## this will return the table as used in ProTracker
proTrackerVibrato(0:31)
}
\author{
Pepijn de Vries
}

