% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/05PTSample.r
\name{sampleLength}
\alias{sampleLength}
\alias{sampleLength,PTSample-method}
\title{Get the length of a PTSample}
\usage{
\S4method{sampleLength}{PTSample}(sample)
}
\arguments{
\item{sample}{A \code{PTSample} object for which the length needs to be returned.}
}
\value{
Returns a \code{numeric} value representing the number of samples
(bytes) the \code{PTSample} object \code{sample} is composed of.
}
\description{
Gets the length (in samples = bytes) of an audio fragment stored as a
\code{\link{PTSample}}.
}
\details{
\code{\link{PTSample}}s are 8 bit mono audio fragments. This method
returns the length of this fragment expressed as number of samples (which
also equals the number of bytes).
}
\examples{
data("mod.intro")

## Show the length of the second sample in mod.intro
sampleLength(PTSample(mod.intro, 2))

}
\seealso{
Other sample.operations: 
\code{\link{PTSample-class}},
\code{\link{PTSample-method}},
\code{\link{fineTune}()},
\code{\link{loopLength}()},
\code{\link{loopSample}()},
\code{\link{loopStart}()},
\code{\link{loopState}()},
\code{\link{name}},
\code{\link{playSample}()},
\code{\link{read.sample}()},
\code{\link{volume}()},
\code{\link{waveform}()},
\code{\link{write.sample}()}
}
\author{
Pepijn de Vries
}
\concept{sample.operations}
