% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/s3.R
\name{format.pt2mod}
\alias{format.pt2mod}
\alias{print.pt2mod}
\alias{format.pt2pat}
\alias{print.pt2pat}
\alias{as.character.pt2pat}
\alias{as.raw.pt2celllist}
\alias{as.raw.pt2celllist.logical}
\alias{as.raw.pt2pat}
\alias{as.raw.pt2pat.logical}
\alias{format.pt2cell}
\alias{print.pt2cell}
\alias{as.character.pt2cell}
\alias{as.raw.pt2cell}
\alias{as.raw.pt2cell.logical}
\alias{format.pt2samp}
\alias{print.pt2samp}
\alias{format.pt2patlist}
\alias{print.pt2patlist}
\alias{format.pt2celllist}
\alias{print.pt2celllist}
\alias{format.pt2samplist}
\alias{print.pt2samplist}
\alias{as.raw.pt2mod}
\alias{as.raw.pt2samp}
\alias{as.integer.pt2samp}
\title{Implementation of basic S3 methods}
\usage{
\method{format}{pt2mod}(x, ...)

\method{print}{pt2mod}(x, ...)

\method{format}{pt2pat}(
  x,
  padding = " ",
  empty_char = "-",
  fmt = getOption("pt2_cell_format"),
  ...
)

\method{print}{pt2pat}(x, sep = "  ", show_header = TRUE, show_row = TRUE, ...)

\method{as.character}{pt2pat}(x, ...)

\method{as.raw}{pt2celllist}(x, ...)

\method{as.raw.pt2celllist}{logical}(x, compact = TRUE, ...)

\method{as.raw}{pt2pat}(x, ...)

\method{as.raw.pt2pat}{logical}(x, compact = TRUE, ...)

\method{format}{pt2cell}(
  x,
  padding = " ",
  empty_char = "-",
  fmt = getOption("pt2_cell_format"),
  ...
)

\method{print}{pt2cell}(x, ...)

\method{as.character}{pt2cell}(x, ...)

\method{as.raw}{pt2cell}(x, ...)

\method{as.raw.pt2cell}{logical}(x, compact = TRUE, ...)

\method{format}{pt2samp}(x, ...)

\method{print}{pt2samp}(x, ...)

\method{format}{pt2patlist}(x, ...)

\method{print}{pt2patlist}(x, ...)

\method{format}{pt2celllist}(x, ...)

\method{print}{pt2celllist}(x, ...)

\method{format}{pt2samplist}(x, ...)

\method{print}{pt2samplist}(x, ...)

\method{as.raw}{pt2mod}(x, ...)

\method{as.raw}{pt2samp}(x, ...)

\method{as.integer}{pt2samp}(x, ...)
}
\arguments{
\item{x}{Object to apply S3 method to. See 'usage' section for allowed object types.}

\item{...}{Passed on to other methods.}

\item{padding}{A \code{vector} of \code{character} strings used to pad between note and instrument number (element 1)
and between instrument number and effect command (element 2). Values are recycled.}

\item{empty_char}{A \code{vector} of single \code{character} values used to represent empty pattern elements.
First element is used for notes, second for instrument number, the third for effect commands.
Values are recycled.}

\item{fmt}{Experimental feature to format a \code{pt2cell}. It should be a named \code{list} containing
formatting strings for elements in the cell. It should contain the elements \code{"note"}, \code{"padding"},
\code{"instrument"} and \code{"effect"}. Its implementation may change in future releases.}

\item{sep}{A separator \code{character} string for concatenating pattern table columns (i.e. channels).}

\item{show_header}{A \code{logical} value indicating if a header should be shown for the
pattern table.}

\item{show_row}{A \code{logical} value indicating if the row of a pattern table should
be labelled with its index.}

\item{compact}{Should the pattern be formatted using a compact notation (as used for
file storage), or a none-compact format as used by the player? This can be
set with the \code{compact} argument.}
}
\value{
The following is returned by the different methods:
\itemize{
\item \code{format}: a formatted \code{character} representation of the object
\item \code{print}: same as \code{format}
\item \code{as.character}: same as \code{format}
\item \code{as.raw}: a \code{raw} representation of the object. In many cases it inherits the same
class as \code{x}
\item \code{as.integer}: converted \code{raw} 8 bit sample data to signed pulse code modulation \code{integer}
values between -128 and +127.
}
}
\description{
Implementation of basic S3 methods, such as, \code{format}, \code{print}, \code{as.raw} and \code{as.character} (
see usage section for a complete overview). See \code{vignette('s3class')} for an overview
of ProTrackR2 S3 class objects. See usage section for an overview of available methods.
}
