% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mcBreaks.R
\name{mcBreaks}
\alias{mcBreaks}
\title{Access Markov Chain Breaks for Run-Off Triangle Increments}
\usage{
mcBreaks(object)
}
\arguments{
\item{object}{An object of the class \code{profileLadder} returned from the function
\code{mcReserve()} or an object of the class \code{mcSetup} returned from the
function \code{incrExplor()}.}
}
\value{
The vector of the break points that define the set of bins for the run-off
triangle increments.
}
\description{
Retrieves the Markov chain components from the output of the \code{incrExplor()}
function or the \code{mcReserve()} function. In particular, the function returns
the set of breaks used to define the bins for the incremental run-off triangle
increments.
}
\examples{
## DEFAULT performance of the incrExplor() function and the MACRAME algorithm
output1 <- incrExplor(CameronMutual)
output2 <- mcReserve(CameronMutual)

## Extracting the DEFAULT break points from both outputs
mcBreaks(output1)
mcBreaks(output2)

## Extracting the corresponding break points for 4 Markov states
mcBreaks(incrExplor(CameronMutual, states = 4))

}
\seealso{
\code{\link[=mcReserve]{mcReserve()}}, \code{\link[=incrExplor]{incrExplor()}}, \code{\link[=mcStates]{mcStates()}}, \code{\link[=mcTrans]{mcTrans()}}
}
