% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/require.package.R
\name{require.package}
\alias{.require.package}
\alias{require.package}
\title{Require a package for use in the project}
\usage{
require.package(package.name, attach = TRUE)

.require.package(package.name)
}
\arguments{
\item{package.name}{A character vector containing the package name.
Must be a valid package name installed on the system.}

\item{attach}{Should the package be attached to the search path (as with
\code{\link{library}}) or not (as with \code{\link{loadNamespace}})?
Defaults to \code{TRUE}. (Internal code will use \code{FALSE} by default
unless a compatibility switch is set, see below.)}
}
\value{
No value is returned; this function is called for its side effects.
}
\description{
This functions will require the given package. If the package is not installed
it will stop execution and print a message to the user instructing them which
package to install and which function caused the error.
}
\details{
The function \code{.require.package} is called by internal code. It will
attach the package to the search path (with a warning) only if the
compatibility configuration \code{attach_internal_libraries} is set to
\code{TRUE}.  Normally, packages used for loading data are not
needed on the search path, but not loading them might break existing code.
In a forthcoming version this compatibility setting will be removed,
and no packages will be attached to the search path by internal code.
}
\examples{
library('ProjectTemplate')

\dontrun{require.package('PackageName')}
}

