\name{internals}
\alias{internals}
\alias{CDF-class}
\alias{Matrix-class}
\alias{Numeric-class}
\alias{Scalar-class}
\alias{Vector-class}
\alias{alt-class}
\alias{bias.corrected.pvalue-class}
\alias{cvalue-class}
\alias{empiricalNull-class}
\alias{est.lfdr.pvalue-class}
\alias{est.lfdr.stat-class}
\alias{est.lfdr.x-class}
\alias{nExpressionSet-class}
\alias{nXprnSet-class}
\alias{nd1class-class}
\alias{nd2class-class}
\alias{nxprnSetObject-class}
\alias{nxprnSetObjectPair-class}
\alias{nxprnSetObjects-class}
\alias{nxprnSetPair-class}
\alias{nxprnSet-class}
\alias{scalar-class}
\alias{ttest-class}
\alias{Combine-methods}
\alias{Combine,Numeric,Numeric-method}
\alias{Combine,Vector,Vector-method}
\alias{Combine,ttest,ttest-method}
\alias{CorrectLimits-methods}
\alias{CorrectLimits,numeric-method}
\alias{[,Matrix,ANY,ANY-method}
\alias{[,Matrix,ANY,missing-method}
\alias{[,Matrix,missing,ANY-method}
\alias{[<-,Matrix,ANY,missing-method}
\alias{Mean-methods}
\alias{Mean,matrix-method}
\alias{Mean,numeric-method}
\alias{Median-methods}
\alias{Median,matrix-method}
\alias{Median,numeric-method}
\alias{[,Numeric,ANY,missing-method}
\alias{[<-,Numeric,ANY,missing-method}
\alias{coerce,Numeric,numeric-method}
\alias{coerce<-,Numeric,numeric-method}
\alias{Rank-methods}
\alias{Rank,numeric-method}
\alias{Rep-methods}
\alias{Rep,Vector-method}
\alias{Rep,matrix-method}
\alias{Rep,nxprnSet-method}
\alias{Sd-methods}
\alias{Sd,numeric-method}
\alias{as.numeric-methods}
\alias{as.numeric,est.lfdr.x-method}
\alias{[,bias.corrected.pvalue,ANY,missing-method}
\alias{coerce,bias.corrected.pvalue,numeric-method}
\alias{coerce<-,bias.corrected.pvalue,numeric-method}
\alias{coerce-methods}
\alias{coerce,cvalue,numeric-method}
\alias{coerce,nExpressionSet,nXprnSet-method}
\alias{coerce,nExpressionSet,numeric-method}
\alias{coerce,nExpressionSet,nxprnSet-method}
\alias{coerce,nxprnSet,nExpressionSet-method}
\alias{coerce,nxprnSet,numeric-method}
\alias{coerce,nxprnSetPair,nxprnSet-method}
\alias{coerce,ttest,cvalue-method}
\alias{coerce<--methods}
\alias{colnames-methods}
\alias{colnames,ANY-method}
\alias{colnames,nd1class-method}
\alias{colnames<--methods}
\alias{colnames<-,ANY,ANY-method}
\alias{colnames<-,nd1class,nd1class-method}
\alias{[,cvalue,ANY,missing-method}
\alias{length,cvalue-method}
\alias{names,cvalue-method}
\alias{dim-methods}
\alias{dim,nxprnSet-method}
\alias{dim,nxprnSetPair-method}
\alias{dimnames-methods}
\alias{dimnames,nxprnSet-method}
\alias{dimnames,nxprnSetPair-method}
\alias{[,est.lfdr.x,ANY,missing-method}
\alias{length,est.lfdr.x-method}
\alias{names,est.lfdr.x-method}
\alias{names<-,est.lfdr.x,character-method}
\alias{exp-methods}
\alias{exp,nExpressionSet-method}
\alias{exp,nxprnSet-method}
\alias{exp,nxprnSetPair-method}
\alias{is_paired-methods}
\alias{is_paired,nd1class,nd1class-method}
\alias{is_paired,nd1class,nd2class-method}
\alias{is_paired,nd2class,nd1class-method}
\alias{is_paired,nd2class,nd2class-method}
\alias{is_positive-methods}
\alias{is_positive,nd1class-method}
\alias{is_positive,nd2class-method}
\alias{is_prob-methods}
\alias{is_prob,numeric-method}
\alias{is_prob,est.lfdr.pvalue-method}
\alias{is_prob,est.lfdr.stat-method}

\alias{length-methods}
\alias{length,nExpressionSet-method}
\alias{length,nxprnSet-method}
\alias{length,nxprnSetPair-method}
\alias{length,ttest-method}
\alias{logb-methods}
\alias{logb,ANY,ANY-method}
\alias{logb,nExpressionSet,missing-method}
\alias{logb,nXprnSet,missing-method}
\alias{logb,nxprnSet,missing-method}
\alias{logb,nxprnSetPair,missing-method}
\alias{[,nExpressionSet,ANY,ANY-method}
\alias{[,nExpressionSet,ANY,missing-method}
\alias{[,nExpressionSet,missing,ANY-method}
\alias{names,nExpressionSet-method}
\alias{nannotation,nExpressionSet-method}
\alias{nexprs,nExpressionSet-method}
\alias{nexprs<-,nExpressionSet,matrix-method}
\alias{nfData,nExpressionSet-method}
\alias{nfeatureNames,nExpressionSet-method}
\alias{npData,nExpressionSet-method}
\alias{nxprnSubset,nExpressionSet-method}
\alias{print,nExpressionSet-method}
\alias{nMatrix-methods}
\alias{nMatrix,matrix-method}
\alias{nMatrix,numeric-method}
\alias{nNumeric-methods}
\alias{nNumeric,numeric-method}
\alias{nScalar-methods}
\alias{nScalar,ANY-method}
\alias{new_nxprnSetPair,nXprnSet,nXprnSet,missing-method}
\alias{nexprs,nXprnSet-method}
\alias{print,nXprnSet-method}
\alias{names-methods}
\alias{names,nxprnSet-method}
\alias{names,nxprnSetPair-method}
\alias{names,ttest-method}
\alias{names<--methods}
\alias{nannotation-methods}
\alias{nannotation,nxprnSet-method}
\alias{nannotation,nxprnSetPair-method}
\alias{ncol-methods}
\alias{ncol,ANY-method}
\alias{ncol,NULL-method}
\alias{ncol,nd1class-method}
\alias{nrow,nd1class-method}
\alias{rownames,nd1class-method}
\alias{new_nxprnSetPair-methods}
\alias{new_nxprnSetPair,matrix,matrix,missing-method}
\alias{new_nxprnSetPair,nxprnSet,missing,character-method}
\alias{new_nxprnSetPair,nxprnSet,nxprnSet,missing-method}

\alias{nexprs<--methods}
\alias{nexprs<-,nxprnSet,matrix-method}
\alias{nexprs<-,nExpressionSet,numeric-method}
\alias{nexprs<-,nxprnSet,numeric-method}

\alias{nexprs-methods}
\alias{nexprs,nxprnSet-method}
\alias{nexprs,nxprnSetPair-method}
\alias{nfData,nxprnSetPair-method}
\alias{npData,nxprnSetPair-method}


\alias{nfData-methods}
\alias{nfData,nxprnSet-method}
\alias{nfeatureNames-methods}
\alias{nfeatureNames,nxprnSet-method}
\alias{nfeatureNames,nxprnSetObjectPair-method}
\alias{nfeatureNames,nxprnSetPair-method}
\alias{npData-methods}
\alias{npData,nxprnSet-method}
\alias{nrow-methods}
\alias{nrow,ANY-method}
\alias{nrow,NULL-method}
\alias{nscalar-methods}
\alias{nscalar,ANY-method}
\alias{nscalar,numeric-method}
\alias{nscalar,scalar-method}
\alias{[,nxprnSetPair,ANY,missing-method}
\alias{print,nxprnSetPair-method}
\alias{removeMissing,nxprnSetPair-method}
\alias{nxprnSubset-methods}
\alias{nxprnSubset,nxprnSet-method}
\alias{[,nxprnSet,ANY,ANY-method}
\alias{[,nxprnSet,ANY,missing-method}
\alias{[,nxprnSet,missing,ANY-method}
\alias{print,nxprnSet-method}
\alias{removeMissing,nxprnSet-method}
\alias{sample_size,nxprnSet-method}
\alias{print-methods}
\alias{print,ANY-method}
\alias{removeMissing-methods}
\alias{rownames-methods}
\alias{rownames,ANY-method}
\alias{s3-methods}
\alias{s3,ANY,character-method}
\alias{s3,ANY,missing-method}
\alias{sameNames-methods}
\alias{sameNames,ANY-method}
\alias{sample_size-methods}
\alias{sample_size,numeric-method}
\alias{sample_size,matrix-method}
\alias{[,ttest,ANY,missing-method}
\alias{[-methods}
\alias{[<--methods}
\alias{BFDR}
\alias{CombinedNames}
\alias{MakeNames}
\alias{Mfrow}
\alias{PHATs.pvalue}
\alias{PHATs.stat}
\alias{PValue}
\alias{PValueFUN}
\alias{Pbinom}
\alias{RepNames}
\alias{SFDR}
\alias{Seq}
\alias{Slot}
\alias{Var}
\alias{are}
\alias{are_null}
\alias{are_prob}
\alias{are_unk}
\alias{as_colmatrix}
\alias{as_rowmatrix}
\alias{assert.are}
\alias{assert.is}
\alias{assumedNull}
\alias{b.notrobust}
\alias{b.robust}
\alias{binom_BFDR}
\alias{binom_limit}
\alias{binom_prob}
\alias{binom_rBFDR}
\alias{binom_rprob}
\alias{blank.plot}
\alias{blank_CDF}
\alias{coercenExpressionSet}
\alias{compatible}
\alias{confidence_CDF}
\alias{default}
\alias{est2list}
\alias{estimated.BFDR}
\alias{estimated.LFDR}
\alias{expected.lfdr}
\alias{get_other.from.testfun}
\alias{get_pvalues}
\alias{get_stats}
\alias{grep_or}
\alias{grepl_or}
\alias{hsm}
\alias{indSortAsY}
\alias{isInteger}
\alias{is_any}
\alias{is_err}
\alias{is_error}
\alias{is_nd1class}
\alias{is_nd2class}
\alias{is_unique}
\alias{is_unk}
\alias{is_vide}
\alias{lfdr}
\alias{lfdr.hbe}
\alias{lfdr.hbea}
\alias{lfdr.hbee}
\alias{list2est}
\alias{list2matrix}
\alias{loccov}
\alias{loccov2}
\alias{locfdr}
\alias{locfdr.rname}
\alias{locmle}
\alias{log_lfdr_se}
\alias{make_labels}
\alias{matrix2list}
\alias{monotonic.pvalue}
\alias{nCDF}
\alias{nalt}
\alias{ncbind}
\alias{ncvalue}
\alias{nempiricalNull}
\alias{new_CDF}
\alias{new_alt}
\alias{new_bias.corrected.pvalue}
\alias{new_cvalue}
\alias{new_empiricalNull}
\alias{new_est.lfdr.pvalue}
\alias{new_est.lfdr.stat}
\alias{new_nExpressionSet}
\alias{new_nxprnSet}
\alias{new_nXprnSet}
\alias{new_ttest}
\alias{nprnSet2matrix}
\alias{nrbind}
\alias{nsize}
\alias{nttest}
\alias{nunique}
\alias{nx11}
\alias{prep.2matrices}
\alias{printGeneric}
\alias{printInvalid}
\alias{print_stats}
\alias{probability_CDF}
\alias{pval2stat}
\alias{removeEQ.from.matrix}
\alias{removeNA.from.matrix}
\alias{removeRC.from.matrix}
\alias{s3_recursive}

\alias{sameAsX_names}
\alias{sameAsY}
\alias{sameLengths}
\alias{sameXY_names}
\alias{se.mean}
\alias{silence}
\alias{sorted}
\alias{spline.des}
\alias{stat2pval}
\alias{stats}
\alias{string2char}
\alias{t_test_CDF}
\alias{undefAsNA}
\alias{vect2string}
\alias{wilkinson.test}
\alias{is_positive}
\alias{CorrectLimits}
\alias{is_prob}
\alias{is_paired}
\alias{s3}
\alias{Rank}
\alias{sameNames}
\alias{Mean}
\alias{Median}
\alias{Sd}
\alias{nNumeric}
\alias{nscalar}
\alias{nScalar}
\alias{nMatrix}
\alias{nexprs}
\alias{nfeatureNames}
\alias{npData}
\alias{nfData}
\alias{nannotation}
\alias{nexprs<-}
\alias{nxprnSubset}
\alias{new_nxprnSetPair}
\alias{removeMissing}
\alias{Rep}
\alias{sample_size}
\alias{Combine}
\title{Internal Functions and Methods}
\description{
These functions are for internal use and/or for upcoming packages or not yet documented.
}
\usage{
BFDR(alpha, P0 = 1, prob.discovery, size)
CombinedNames(object,
	 xlab = "x", ylab = "y")
MakeNames(x, nmvar = c("X", "I"), force = FALSE,
	 n0 = 1)
Mfrow(half = FALSE, quarter = FALSE, mfrow, height = 2.5,
	 width = 1.5, mai = c(0.7, 0.7, 0.6, 0.3), ...)
PHATs.pvalue(lfdr.fun = "rvalue",
	 pvalue, p0 = NULL, robust = FALSE, monotonic = FALSE,
	 ...)
PHATs.stat(lfdr.fun = "lfdr.hbea", stat = NULL, pvalue = NULL,
	 plot = 0, nulltype = 1, bre = 120, df = 7, ...)
PValue(object,
	 get.PValue, alternative = default("Greater", "alternative"),
	 verbose = TRUE, ...)
PValueFUN(FUN, alternative, ...)
Pbinom(x, size, prob,
	 lower.tail = TRUE, correct = default(TRUE, "Pbinom correct"),
	 correction = if (correct) 1/2 else 0, inclusive = TRUE, verbose = FALSE)
	RepNames(object, times, unique = TRUE, ...)
SFDR(alpha, P0, size,
	 prob.discovery)
Seq(from, to, return.na.on.error = FALSE)
	Slot(object, name)
Var(...)
are(object, class2)
are_null(object)
	are_prob(object, ...)
are_unk(object)
as_colmatrix(x)
as_rowmatrix(x)
	assert.are(object, class2, ...)
assert.is(object, class2, text = "")
	assumedNull(object, ...)
b.notrobust(object, P0, ...)
b.robust(object,
	 P0, ...)
binom_BFDR(x, size, alpha, p = numeric(0), n = numeric(0),
	 P0 = 1, max.BFDR = 1, FUN = NULL, conservative = logical(0), correct,
	 BFDR.fun, ...)
binom_limit(x, size, p, correct = default(TRUE,
	 "binom_limit correct"), ...)
binom_prob(x, size, p, alternative = character(0),
	 correct = TRUE, ...)
binom_rBFDR(x, size, alpha, n,
	 correct = default(TRUE, "binom_rBFDR correct"), ...)
binom_rprob(x,
	 size, n, FUN = binom_prob, ...)
blank.plot(legend, ...)
blank_CDF(object,
	 param.name = "no parameter")
coercenExpressionSet(from, to.fun,
	 ...)
compatible(...)
confidence_CDF(object, pvalue.fun, param.name,
	 min_param, max_param, ...)
default(object, name, verbose,
	 return.value = object)
est2list(x)
estimated.BFDR(object, alpha, nfeature,
	 P0 = 1, p = numeric(0), n = numeric(0), ndiscovery.correction = 0,
	 correct, verbose = FALSE, ...)
estimated.LFDR(object, monotonic = FALSE,
	 p = numeric(0), save.time = FALSE, verbose = FALSE,
	 ties.method = "random", achieved.BFDR.fun = estimated.BFDR, ...)
	expected.lfdr(object, call.plot = FALSE, ...)
get_other.from.testfun(x,
	 y = NULL, test.fun = t.test, paired = FALSE, opt = "parameter", ...)
	get_pvalues(x, y = NULL, test.fun = t.test, paired = FALSE, ...)
	get_stats(x, y = NULL, test.fun = t.test, paired = FALSE, ...)
grep_or(x,
	 pattern, fixed = FALSE, exact = FALSE, ind = T, unik = T, ...)
	grepl_or(x, pattern, fixed = FALSE, exact = FALSE, unik = T, ...)
	hsm(x, na.rm)
indSortAsY(x, y, inter = F, ind = T)
isInteger(x)
	is_any(object, class2)
is_err(object)
is_error(object)
is_nd1class(x)
	is_nd2class(x)
is_unique(object)
is_unk(object)
is_vide(object)
	lfdr(object, zz, use.s3, factor = numeric(0), max.lfdr = Inf, ...)
	lfdr.hbe(stat = NULL, pvalue = NULL, nulltype = 1, bre = 120, df = 7,
	 plot = 0, ...)
lfdr.hbea(stat = NULL, pvalue = NULL, nulltype = 1,
	 bre = 120, df = 7, plot = 0, ...)
lfdr.hbee(stat = NULL, pvalue = NULL,
	 nulltype = 1, bre = 120, df = 7, plot = 0, ...)
list2est(x,
	 n.object = NULL)
list2matrix(x)
loccov(N, N0, p0, d, s, x, X, f, JV,
	 Y, i0, H, h, sw)
loccov2(X, X0, i0, f, ests, N)
locfdr(zz, bre = 120,
	 df = 7, pct = 0, pct0 = 1/4, nulltype = 1, type = 0, plot = 1,
	 mult, mlests, main = " ", sw = 0)
locfdr.rname(nulltype)
locmle(z,
	 xlim, Jmle = 35, d = 0, s = 1, ep = 1/1e+05, sw = 0, Cov.in)
	log_lfdr_se(object, call.plot = FALSE, ...)
make_labels(n, nmvar = c("X"),
	 n.ini = 1)
matrix2list(x)
monotonic.pvalue(object, corrected,
	 uncorrected, ranks = numeric(0), monotonic = TRUE)
nCDF(type, ...)
	nalt(object)
ncbind(x, y = NULL, inter = FALSE)
ncvalue(object, s3FUN,
	 alternative, ttest.arglis, verbose = TRUE, ...)
nempiricalNull(object,
	 nulltype = default(1, "nulltype"), nsilence = 0, silent = NULL,
	 call.browser = FALSE, cvalue.arglis = NULL, verbose = TRUE, max.p0 = 1,
	 ...)
new_CDF(object, min_param, max_param, param.name, type)
	new_alt(object)
new_bias.corrected.pvalue(object, uncorrected,
	 ranks = numeric(0))
new_cvalue(pvalue, zz, s3FUN, arglis)
new_empiricalNull(PDF,
	 PDF0, CDF0, p0, s3, min_param = default(-Inf, "min_param"),
	 max_param = default(Inf, "max_param"), max.p0 = 1)
new_est.lfdr.pvalue(LFDR.hat, p0.hat, pvalue, method = NULL, info = list())
new_est.lfdr.stat(LFDR.hat, p0.hat, stat, method = NULL, info = list())
new_nExpressionSet(x=matrix(0),phenoData=as.data.frame(NULL),
                   featureData=as.data.frame(NULL),
	annotation = character(0))
new_nxprnSet(phenoData = as.data.frame(NULL),
	 exprs = matrix(0), featureData = as.data.frame(NULL),
	 annotation = character(0))
new_nXprnSet(phenoData = as.data.frame(NULL),exprs = matrix(0),
	featureData = as.data.frame(NULL),annotation = character(0))
	new_ttest(pvalue, stat, df, alternative, level1, level2)
	nprnSet2matrix(x, y = NULL, paired = FALSE)
nrbind(x, y = NULL, inter = FALSE)
	nsize(x)
nttest(x, y, factor.name, level1, level2,
	 alternative = "greater", ...)
nunique(x, y = NULL, vip = 1)
nx11(height = 2.5,
	 width = 1.5, pointsize = 8, mai = c(0.7, 0.7, 0.6, 0.3), ...)
	prep.2matrices(x, y = NULL, paired = FALSE, rm.na = T)
printGeneric(object,
	 ...)
printInvalid(object, ...)
print_stats(object, name, ...)
	probability_CDF(object, param.name = default("parameter", "param.name"),
	 min_param, max_param, ...)
pval2stat(x, qFUN = qt,
	 alternative = "greater", ...)
removeEQ.from.matrix(x, indx = FALSE)
	removeNA.from.matrix(x, indx = FALSE)
removeRC.from.matrix(x, opt = "NA",
	 indx = FALSE)
s3_recursive(object, name, first.call)

sameAsX_names(x = NULL, y = NULL)
sameAsY(x = NULL,
	 y = NULL)
sameLengths(...)
sameXY_names(x = NULL, y = NULL)
	se.mean(...)
silence(z, nsilence, silent = NULL)
sorted(object,
	 ...)
spline.des(knots, x, ord = 4, derivs = integer(length(x)),
                 outer.ok = FALSE, sparse = FALSE)
stat2pval(x,
	 pFUN = pt, alternative = "two.sided", sym.distrib = T, ...)
	stats(object, ...)
string2char(x, ...)
t_test_CDF(object, ...)
undefAsNA(x)
	vect2string(x, sep = "", ...)
wilkinson.test(x, mu = 0,
	 alternative = "greater")
}
\keyword{internal}

