% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PWV1_static.R
\name{pair_similarity}
\alias{pair_similarity}
\title{Compute cosine similarity/distance for a pair of words.}
\usage{
pair_similarity(data, word1, word2, distance = FALSE)
}
\arguments{
\item{data}{A \code{\link[PsychWordVec:as_wordvec]{wordvec}} (data.table) or
\code{\link[PsychWordVec:as_embed]{embed}} (matrix),
see \code{\link{data_wordvec_load}}.}

\item{word1, word2}{Word string (a single word).}

\item{distance}{Compute cosine distance instead?
Defaults to \code{FALSE} (cosine similarity).}
}
\value{
A value of cosine similarity/distance.
}
\description{
Compute cosine similarity/distance for a pair of words.
}
\section{Download}{

Download pre-trained word vectors data (\code{.RData}):
\url{https://psychbruce.github.io/WordVector_RData.pdf}
}

\examples{
pair_similarity(demodata, "China", "Chinese")

}
\seealso{
\code{\link{cosine_similarity}}

\code{\link{plot_similarity}}

\code{\link{tab_similarity}}

\code{\link{most_similar}}
}
