% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PWV1_static.R
\name{sum_wordvec}
\alias{sum_wordvec}
\title{Calculate the sum vector of multiple words.}
\usage{
sum_wordvec(data, x = NULL, verbose = TRUE)
}
\arguments{
\item{data}{A \code{\link[PsychWordVec:as_wordvec]{wordvec}} (data.table) or
\code{\link[PsychWordVec:as_embed]{embed}} (matrix),
see \code{\link{data_wordvec_load}}.}

\item{x}{Can be:
\itemize{
  \item{\code{NULL}: use the sum of all word vectors in \code{data}}
  \item{a single word:

  \code{"China"}}

  \item{a list of words:

  \code{c("king", "queen")}}

  \code{cc(" king , queen ; man | woman")}

  \item{an R formula (\code{~ xxx}) specifying
  words that positively and negatively
  contribute to the similarity (for word analogy):

  \code{~ boy - he + she}

  \code{~ king - man + woman}

  \code{~ Beijing - China + Japan}}
}}

\item{verbose}{Print information to the console? Defaults to \code{TRUE}.}
}
\value{
Normalized sum vector.
}
\description{
Calculate the sum vector of multiple words.
}
\section{Download}{

Download pre-trained word vectors data (\code{.RData}):
\url{https://psychbruce.github.io/WordVector_RData.pdf}
}

\examples{
sum_wordvec(demodata, ~ king - man + woman)

}
\seealso{
\code{\link{most_similar}}

\code{\link{dict_expand}}

\code{\link{dict_reliability}}
}
