% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_synonyms.R
\name{get_synonyms}
\alias{get_synonyms}
\title{Retrieve Synonyms from PubChem}
\usage{
get_synonyms(
  identifier,
  namespace = "cid",
  domain = "compound",
  searchtype = NULL,
  options = NULL
)
}
\arguments{
\item{identifier}{A character or numeric value specifying the identifier for the request.}

\item{namespace}{A character string specifying the namespace for the request. Default is 'cid'.}

\item{domain}{A character string specifying the domain for the request. Default is 'compound'.}

\item{searchtype}{A character string specifying the search type. Default is NULL.}

\item{options}{Additional arguments passed to \code{\link{get_json}}.}
}
\value{
A list where each element corresponds to the synonyms retrieved from PubChem for the provided identifier.
        The names of the list elements are based on the provided identifier.
}
\description{
This function sends a request to PubChem to retrieve synonyms for a given identifier.
It returns a list of synonyms corresponding to the provided identifier.
}
\examples{
get_synonyms(
  identifier = "aspirin",
  namespace = "name"
)
}
