% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_pug_rest.R
\name{get_pug_rest}
\alias{get_pug_rest}
\title{Retrieve Data from PubChem PUG REST API}
\usage{
get_pug_rest(
  identifier = NULL,
  namespace = "cid",
  domain = "compound",
  operation = NULL,
  output = "JSON",
  searchtype = NULL,
  property = NULL,
  options = NULL,
  save = FALSE,
  dpi = 300,
  path = NULL,
  file_name = NULL,
  ...
)
}
\arguments{
\item{identifier}{A vector of identifier for the query, either numeric or character.}

\item{namespace}{A character string specifying the namespace for the request. Default is 'cid'.}

\item{domain}{A character string specifying the domain for the request. Default is 'compound'.}

\item{operation}{An optional character string specifying the operation for the request.}

\item{output}{A character string specifying the output format. Possible values are 'SDF', 'JSON', 'JSONP', 'CSV', 'TXT', and 'PNG'. Default is 'JSON'.}

\item{searchtype}{An optional character string specifying the search type.}

\item{property}{An optional character string specifying the property for the request.}

\item{options}{A list of additional options for the request.}

\item{save}{A logical value indicating whether to save the output as a file or image. Default is FALSE.}

\item{dpi}{An integer specifying the DPI for image output. Default is 300.}

\item{path}{description}

\item{file_name}{a character of length 1. Define the name of file (without file extension) to save. If NULL, default file name is set as "files_downloaded".}

\item{...}{description}
}
\value{
Depending on the output format, this function returns different types of content:
        JSON or JSONP format returns parsed JSON content.
        CSV format returns a data frame.
        TXT format returns a table.
        SDF returns SDF file of requested identifier.
        PNG format returns an image object or saves an image file.
}
\description{
This function sends a request to the PubChem PUG REST API to retrieve various types of data
for a given identifier. It supports fetching data in different formats and allows saving the output.
}
\examples{
result <- get_pug_rest(identifier = "2244", namespace = "cid", domain = "compound", output = "JSON")

}
