% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_substances.R
\name{get_substances}
\alias{get_substances}
\title{Retrieve Substances from PubChem}
\usage{
get_substances(
  identifier,
  namespace = "sid",
  operation = NULL,
  searchtype = NULL,
  options = NULL
)
}
\arguments{
\item{identifier}{A character or numeric vector specifying the identifiers for the request.}

\item{namespace}{A character string specifying the namespace for the request. Default is 'sid'.}

\item{operation}{Specifies the operation to be performed on the input records. For the 'compound' domain, possible operations include 'record', 'property', 'synonyms', 'sids', 'cids', 'aids', 'assaysummary', 'classification', 'xrefs', and 'description'. The available operations are domain-specific.}

\item{searchtype}{Specifies the type of search to be performed. For structure searches, possible values are combinations of 'substructure', 'superstructure', 'similarity', 'identity' with 'smiles', 'inchi', 'sdf', 'cid'. For fast searches, possible values are combinations of 'fastidentity', 'fastsimilarity_2d', 'fastsimilarity_3d', 'fastsubstructure', 'fastsuperstructure' with 'smiles', 'smarts', 'inchi', 'sdf', 'cid', or 'fastformula'.}

\item{options}{Additional parameters passed to PubChem request.}
}
\value{
An object of class 'PubChemInstanceList' containing all the substance information of requested compounds.
}
\description{
This function sends a request to PubChem to retrieve substance data based on the specified parameters.
}
\examples{
\donttest{
subs <- get_substances(
  identifier = c("aspirin", "ibuprofen"),
  namespace = "name"
)

instance(subs, "aspirin")
retrieve(instance(subs, "aspirin"), "source")
}

}
