% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.univariateTable.R
\name{summary.univariateTable}
\alias{summary.univariateTable}
\title{Preparing univariate tables for publication}
\usage{
\method{summary}{univariateTable}(object, n = "inNames",
  drop.reference = FALSE, pvalue.stars = FALSE, pvalue.digits = 4,
  show.missing = c("ifany", "always", "never"), show.pvalues,
  show.totals, ...)
}
\arguments{
\item{object}{\code{univariateTable} object as obtained with
function \code{univariateTable}.}

\item{n}{If not missing, show the number of subjects in each
column. If equal to \code{"inNames"}, show the numbers in
parentheses in the column names.  If missing the value
\code{object$n} is used.}

\item{drop.reference}{Logical or character (vector). Decide if line with reference
level should be suppressed for factors. If \code{TRUE} or \code{"all"}
suppress for all categorical factors. If \code{'binary'} suppress only for binary variables.
Can be character vector in which case reference lines are suppressed for variables
that are included in the vector.}

\item{pvalue.stars}{If TRUE use \code{symnum} to parse p-values
otherwise use \code{format.pval}.}

\item{pvalue.digits}{Passed to \code{format.pval}.}

\item{show.missing}{Decides if number of missing values are shown in table.
Defaults to \code{"ifany"}, and can also be set to \code{"always"} or \code{"never"}.}

\item{show.pvalues}{Logical. If set to \code{FALSE} the column
\code{p-values} is removed. If missing the value
\code{object$compare.groups[[1]]==TRUE} is used.}

\item{show.totals}{Logical. If set to \code{FALSE} the column
\code{Totals} is removed. If missing the value
\code{object$show.totals} is used.}

\item{...}{passed on to \code{labelUnits}. This overwrites labels
stored in \code{object$labels}}
}
\value{
Summary table
}
\description{
Summary function for univariate table
}
\details{
Collects results of univariate table in a matrix.
}
\examples{
data(Diabetes)
u <- univariateTable(gender~age+location+Q(BMI)+height+weight,
                data=Diabetes)
summary(u)
summary(u,n=NULL)
summary(u,pvalue.digits=2,"age"="Age (years)","height"="Body height (cm)")

u2 <- univariateTable(location~age+AgeGroups+gender+height+weight,
                data=Diabetes)
summary(u2)
summary(u2,drop.reference=TRUE)
## same but more flexible
summary(u2,drop.reference=c("binary"))
## same but even more flexible
summary(u2,drop.reference=c("gender"))


}
\author{
Thomas A. Gerds <tag@biostat.ku.dk>
}
