% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pubformat.R
\name{pubformat}
\alias{pubformat}
\title{Format numbers for publication}
\usage{
pubformat(x, digits = 2, nsmall = digits, handler = "sprintf", ...)
}
\arguments{
\item{x}{numeric vector}

\item{digits}{number of digits}

\item{nsmall}{see handler}

\item{handler}{String specififying the name of the function which should
perform the formatting. See \code{sprintf}, \code{format} and \code{prettyNum}.}

\item{...}{Passed to handler function if applicable, i.e., not to \code{sprintf}.}
}
\value{
Formatted number
}
\description{
Format numbers according to a specified handler function.
Currently supported are sprintf, format and prettyNum.
}
\examples{

pubformat(c(0.000143,12.8,1))
pubformat(c(0.000143,12.8,1),handler="format")
pubformat(c(0.000143,12.8,1),handler="format",trim=TRUE)
pubformat(c(0.000143,12.8,1),handler="prettyNum")
}
\seealso{
\code{sprintf}, \code{format}, \code{prettyNum}
}
\author{
Thomas A. Gerds <tag@biostat.ku.dk>
}
