% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parser.R
\name{read_luminex_data}
\alias{read_luminex_data}
\title{Read Luminex Data}
\usage{
read_luminex_data(
  plate_filepath,
  layout_filepath = NULL,
  format = "xPONENT",
  plate_file_separator = ",",
  plate_file_encoding = "UTF-8",
  use_layout_sample_names = TRUE,
  use_layout_types = TRUE,
  use_layout_dilutions = TRUE,
  default_data_type = "Median",
  sample_types = NULL,
  dilutions = NULL,
  verbose = TRUE
)
}
\arguments{
\item{plate_filepath}{Path to the Luminex plate file}

\item{layout_filepath}{Path to the Luminex layout file}

\item{format}{The format of the Luminex data. Select from: xPONENT, INTELLIFLEX}

\item{plate_file_separator}{The separator used in the plate file}

\item{plate_file_encoding}{The encoding used in the plate file}

\item{use_layout_sample_names}{Whether to use names from the layout file in extracting sample names.}

\item{use_layout_types}{Whether to use names from the layout file in extracting sample types.
Works only when layout file is provided}

\item{use_layout_dilutions}{Whether to use dilutions from the layout file in extracting dilutions.
Works only when layout file is provided}

\item{default_data_type}{The default data type to use if none is specified}

\item{sample_types}{a vector of sample types to use instead of the extracted ones}

\item{dilutions}{a vector of dilutions to use instead of the extracted ones}

\item{verbose}{Whether to print additional information and warnings. \code{TRUE} by default}
}
\value{
Plate file containing the Luminex data
}
\description{
Reads a file containing Luminex data and returns a Plate object.
If provided, can also read a layout file, which usually contains
information about the sample names, sample types or its dilutions.

The function is capable of reading data in two different formats:
\itemize{
\item xPONENT
\item INTELLIFLEX
which are produced by two different Luminex machines.
}
}
\examples{
plate_file <- system.file("extdata", "CovidOISExPONTENT.csv", package = "PvSTATEM")
layout_file <- system.file("extdata", "CovidOISExPONTENT_layout.csv", package = "PvSTATEM")
plate <- read_luminex_data(plate_file, layout_file)

plate_file <- system.file("extdata", "CovidOISExPONTENT_CO.csv", package = "PvSTATEM")
layout_file <- system.file("extdata", "CovidOISExPONTENT_CO_layout.xlsx", package = "PvSTATEM")
# To suppress warnings and additional information use verbose = FALSE
plate <- read_luminex_data(plate_file, layout_file, verbose = FALSE)

}
