% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qbms.R
\name{list_studies}
\alias{list_studies}
\title{Get the List of Studies in the Current Active Trial}
\usage{
list_studies()
}
\value{
A list of study and location names.
}
\description{
Retrieves the studies list from the current active trial as configured in the 
internal state object using `set_trial()` function.
}
\examples{
if(interactive()) {
  # Configure your server connection
  set_qbms_config("https://bms.icarda.org/ibpworkbench")

  # Login using your account (interactive mode)
  # You can pass your username and password as parameters (batch mode)
  login_bms()

  # Select a crop by name
  set_crop("wheat")

  # Select a breeding program by name
  set_program("Wheat International Nurseries")

  # Select a specific study/trial by name
  set_trial("IDYT39")

  # List all environments/locations information in the selected study/trial
  list_studies()
}

}
\seealso{
\code{\link{login_bms}}, \code{\link{set_crop}}, \code{\link{set_program}}, \code{\link{set_trial}}
}
\author{
Khaled Al-Shamaa, \email{k.el-shamaa@cgiar.org}
}
