% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/auth.R
\name{login_bms}
\alias{login_bms}
\title{Login to the Server}
\usage{
login_bms(username = NULL, password = NULL, encoding = "json")
}
\arguments{
\item{username}{The username (optional, default is NULL). If not provided, the pop-up window is triggered.}

\item{password}{The password (optional, default is NULL). If not provided, the pop-up window is triggered.}

\item{encoding}{Specifies how the request body should be encoded: `form` (application/x-www-form-urlencoded), 
`multipart` (multipart/form-data), or `json` (application/json). Default is "json".}
}
\value{
No return value. The access token is stored internally for future use.
}
\description{
Connects to the BMS or related server using a username and password. If these are not provided,
a pop-up window will prompt the user to enter their credentials. The function handles authentication 
and stores the resulting access token internally for subsequent requests.
}
\examples{
if(interactive()) {
  set_qbms_config("https://bms.icarda.org/ibpworkbench")
  login_bms()
}

}
\author{
Khaled Al-Shamaa, \email{k.el-shamaa@cgiar.org}
}
