% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Distributions_QF.R
\name{QF}
\alias{QF}
\alias{dQF}
\alias{pQF}
\alias{qQF}
\alias{rQF}
\title{Positive Definite Quadratic Forms Distribution}
\usage{
dQF(x, obj)

pQF(q, obj)

qQF(p, obj, eps_quant = 1e-06, maxit_quant = 10000)

rQF(n, lambdas, etas = rep(0, length(lambdas)))
}
\arguments{
\item{x, q}{vector of quantiles.}

\item{obj}{\code{MellinQF} object produced by the \code{\link{compute_MellinQF}} function.}

\item{p}{vector of probabilities.}

\item{eps_quant}{relative error for quantiles.}

\item{maxit_quant}{maximum number of Newton-Raphson iterations allowed to compute quantiles.}

\item{n}{number of observations.}

\item{lambdas}{vector of positive weights.}

\item{etas}{vector of non-centrality parameters. Default all zeros.}
}
\value{
\code{dQF} provides the values of the density function at a quantile \code{x}.

\code{pQF} provides the cumulative distribution function at a quantile \code{q}.

\code{qQF} provides the quantile corresponding to a probability level \code{p}.

\code{rQF} provides a sample of \code{n} independent realizations from the QF.
}
\description{
Density function, distribution function, quantile function and random generator for positive definite QFs.
}
\details{
The quadratic form CDF and PDF are evaluated by numerical inversion of the Mellin transform.
The absolute error specified in \code{\link{compute_MellinQF}} is guaranteed for values of \code{q} and \code{x} inside the \code{range_q}.
If the quantile is outside \code{range_q}, computations are carried out, but a warning is sent.

The function uses the Newton-Raphson algorithm to compute the QF quantiles related to probabilities \code{p}.
}
\examples{
\donttest{
library(QF)
# Definition of the QF
lambdas_QF <- c(rep(7, 6),rep(3, 2))
etas_QF <- c(rep(6, 6), rep(2, 2))
# Computation Mellin transform
eps <- 1e-7
rho <- 0.999
Mellin <- compute_MellinQF(lambdas_QF, etas_QF, eps = eps, rho = rho)
xs <- seq(Mellin$range_q[1], Mellin$range_q[2], l = 100)
# PDF
ds <- dQF(xs, Mellin)
plot(xs, ds, type="l")
# CDF
ps <- pQF(xs, Mellin)
plot(xs, ps, type="l")
# Quantile
qs <- qQF(ps, Mellin)
plot(ps, qs, type="l")
#Comparison computed quantiles vs real quantiles
plot((qs - xs) / xs, type = "l")

}

}
\seealso{
See \code{\link{compute_MellinQF}} for details on the Mellin computation.
}
