% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.cmprsk.R
\name{predict.cmprsk}
\alias{predict.cmprsk}
\title{Calculate Predicted Competing Risks Probability}
\usage{
\S3method{predict}{cmprsk}(object, newdata = NULL, time, 
lps = FALSE, \dots)
}
\arguments{
\item{object}{a saved crr model fit crated by function
\code{crr.fit}}

\item{newdata}{data frame for prediction. Each row of the data
frame   contains values of covariates that are required in the crr
model. If   missing, the original data set that was used to
develop the crr model   will be used for prediction.}

\item{time}{expected time point for evaluating the competing risks
probability.}

\item{lps}{set \code{TRUE} to return linear predictor values
instead of   failure probabilities.}

\item{...}{other arguments}
}
\value{
A vector with the length equal to the number of rows in the data
  frame, which was used to make prediction. Each element corresponds to a
  predicted failure probability at the expected time point.
}
\description{
Calculate Predicted Competing Risks Probability.
}
\details{
Calculate predicted probabilities for a competing risks regression model,
which is fitted by function \code{\link[QHScrnomo]{crr.fit}}.
}
\note{
This function is adapted from function
  \code{\link[cmprsk]{predict.crr}} in package \code{cmprsk}.
}
\examples{

data(prostate.dat)
dd <- datadist(prostate.dat)
options(datadist = "dd")
prostate.f <- cph(Surv(TIME_EVENT,EVENT_DOD == 1) ~ TX  + rcs(PSA,3) +
           BX_GLSN_CAT +  CLIN_STG + rcs(AGE,3) +
           RACE_AA, data = prostate.dat,
           x = TRUE, y= TRUE, surv=TRUE,time.inc = 144)
prostate.crr <- crr.fit(prostate.f,cencode = 0,failcode = 1)
prostate.dat$pred.60 <- predict(prostate.crr, time=60)


}
\references{
\code{ Fine JP and Gray RJ (1999)} A proportional hazards model
  for the subdistribution of a competing risk.  \code{JASA} 94:496-509.
}
\seealso{
\code{\link[QHScrnomo]{crr.fit}},
  \code{\link[cmprsk]{predict.crr}}
}
\author{
Michael W. Kattan, Ph.D. and Changhong Yu.\cr Department of
  Quantitative Health Sciences, Cleveland Clinic
}
\keyword{datagen}
\keyword{survival}
