% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Newlabels.R
\name{Newlabels.cmprsk}
\alias{Newlabels.cmprsk}
\title{Change the Predictor Labels for a Competing Risks Regression Model}
\usage{
\S3method{Newlabels}{cmprsk}(fit, labels, \dots)
}
\arguments{
\item{fit}{A model fit by \code{\link[QHScrnomo]{crr.fit}}}

\item{labels}{A character vector specifying the new labels for variables in a fit.}

\item{...}{Other arguments for \code{\link[rms]{Newlabels}}}
}
\value{
A new \code{\link[QHScrnomo]{crr.fit}} object with adjusted labels
}
\description{
Uses the \code{\link[rms]{Newlabels}} function to change the labels predictors when constructing a nomogram.
}
\details{
To give new labels for all variables, you can specify labels of the
form \code{labels = c("Age in Years","Cholesterol")}, where the list of new labels
is assumed to be the length of all main effect-type variables in the fit
and in their original order in the model formula. You may specify a named
vector to give new labels in any order for a subset of the variables,
e.g., \code{labels = c(age = "Age in Years", chol = "Cholesterol")}.
}
\examples{
dd <- datadist(prostate.dat)
options(datadist = "dd")
prostate.f <- cph(Surv(TIME_EVENT,EVENT_DOD == 1) ~ TX  + rcs(PSA,3) +
           BX_GLSN_CAT +  CLIN_STG + rcs(AGE,3) +
           RACE_AA, data = prostate.dat,
           x = TRUE, y = TRUE, surv = TRUE,time.inc = 144)
prostate.crr <- crr.fit(prostate.f, cencode = 0, failcode = 1)
prostate.g <- Newlabels(
prostate.crr,
c(
  TX = 'Treatment options',
  BX_GLSN_CAT = 'Biopsy Gleason Score Sum',
  CLIN_STG = 'Clinical stage'
)
)

}
\seealso{
\code{\link[QHScrnomo]{Newlevels.cmprsk}}
}
\author{
Changhong Yu. Department of
Quantitative Health Sciences, Cleveland Clinic
}
\keyword{attributes}
