% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/D.make.R
\name{D.make}
\alias{D.make}
\title{Generate D Matrix}
\usage{
D.make(
  nQTL,
  type = "RI",
  a = TRUE,
  d = TRUE,
  aa = FALSE,
  dd = FALSE,
  ad = FALSE
)
}
\arguments{
\item{nQTL}{integer. The number of QTLs.}

\item{type}{character. The population type of the dataset. Include
backcross (type="BC"), advanced intercross population (type="AI"), and
recombinant inbred population (type="RI"). The default is type="RI".}

\item{a}{integer or vector. A integer or vector to decide the additive
effects of which QTL will be considered in this design matrix. If
a=TRUE, the additive effect of all QTLs will be considered. If
a=FALSE, no additive effect will be considered.}

\item{d}{integer or vector. A integer or vector to decide the dominant
effects of which QTL will be considered in this design matrix. If
d=TRUE, the dominant effect of all QTLs will be considered.If
d=FALSE, no dominant effect will be considered.}

\item{aa}{vector or matrix. The additive-by-additive interaction. Tow
format can be used in this parameter. One format is vector, in which
every two elements indicate a combination of additive-by-additive
interaction. The other format is a 2*i matrix, where i is the number
of combinations of interaction, and each column indicates the two
interacting QTLs. Besides, if aa=TRUE, all combinations of
additive-by-additive interaction will be considered. If aa=FALSE, no
additive-by-additive interaction will be considered.}

\item{dd}{vector or matrix. The dominant-by-dominant interaction. The
format is the same as that in aa.}

\item{ad}{vector or matrix. The additive-by-dominant interaction. The
format is the same as that in aa. Note that, in each pair of QTLs, the
first element indicates the additive effect, and the second indicates
the dominant effect.}
}
\value{
The genetic design matrix, whose elements are the coded variables of
the QTL effects. It is a g*p matrix, where g is the number of possible
QTL genotypes, and p is the number of effects in the MIM model.
}
\description{
Generate the genetic design matrix of specified QTL number and effects.
}
\note{
For parameter type, if type="BC", the design matrix contains only
additive effect and additive by additive interaction. If type="AI" or
type="RI", that will contain additive and dominance effects and all
interaction.

For example, when aa=c(1,3,2,4,5,6), indicates that the interaction
between QTL1 and QTL3, the interaction between QTL2 and QTL4, and that
between QTL5 and QTL6 will be considered in the design matrix. Besides,
the matrix format can be expressed as aa=matrix(c(1,3,2,4,5,6),2,3).
The parameters DD and AD are also expressed in the same way.
}
\examples{
D.make(4, d = c(1,3,4), aa = c(1,2,2,3), dd = c(1,3,1,4), ad = c(1,2,2,1,2,3,3,4))

aa <- matrix(c(1,2,3,4,4,5), 2, 3)
aa
D.make(5, type = "BC", a = c(1,3,4,5), aa = aa)
}
\references{
KAO, C.-H. and Z.-B. ZENG 1997 General formulas for obtaining the maximum
likelihood estimates and the asymptotic variance-covariance matrix in QTL
mapping when using the EM algorithm. Biometrics 53, 653-665.

KAO, C.-H., Z.-B. ZENG and R. D. TEASDALE 1999 Multiple interval mapping
for Quantitative Trait Loci. Genetics 152: 1203-1216.
}
