% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rpartD.R
\name{rpartD}
\alias{rpartD}
\alias{m_rpartD}
\title{Dichotomize via Recursive Partitioning}
\usage{
rpartD(
  y,
  x,
  check_degeneracy = TRUE,
  cp = .Machine$double.eps,
  maxdepth = 2L,
  ...
)

m_rpartD(y, X, check_degeneracy = TRUE, ...)
}
\arguments{
\item{y}{a \link[survival]{Surv} object,
a \link[base]{logical} \link[base]{vector},
or a \link[base]{double} \link[base]{vector}, the response \eqn{y}}

\item{x}{\link[base]{numeric} \link[base]{vector}, one predictor \eqn{x}}

\item{check_degeneracy}{\link[base]{logical} scalar, whether to allow the
dichotomized value to be all-\code{FALSE} or all-\code{TRUE} (i.e., degenerate)
for any one of the predictors.
Default \code{TRUE} to produce a \link[base]{warning} message for degeneracy.}

\item{cp}{\link[base]{double} scalar, complexity parameter, see \link[rpart]{rpart.control}.
Default \code{.Machine$double.eps}, so that a split is enforced
no matter how small improvement in overall \eqn{R^2} is}

\item{maxdepth}{positive \link[base]{integer} scalar, maximum depth of any node, see \link[rpart]{rpart.control}.
Default \code{2L}, because only the first node is needed}

\item{...}{additional parameters of \link[rpart]{rpart} and/or \link[rpart]{rpart.control}}

\item{X}{\link[base]{numeric} \link[base]{matrix},
a set of predictors.
Each column of \eqn{X} is one predictor.}
}
\value{
\subsection{Dichotomize Single Predictor}{

Function \link{rpartD} returns a \link[base]{function},
with a \link[base]{double} \link[base]{vector} parameter \code{newx}.
The returned value of \code{rpartD(y,x)(newx)} is a
\link[base]{logical} \link[base]{vector}
with \link[base]{attributes}
\describe{
\item{\code{attr(,'cutoff')}}{\link[base]{double} scalar, the cutoff value for \code{newx}}
}
}

\subsection{Dichotomize Multiple Predictors}{

Function \link{m_rpartD} returns a \link[base]{function},
with a \link[base]{double} \link[base]{matrix} parameter \code{newX}.
The argument for \code{newX} must have
the same number of columns and the same column names as
the input \link[base]{matrix} \eqn{X}.
The returned value of \code{m_rpartD(y,X)(newX)} is a
\link[base]{logical} \link[base]{matrix}
with \link[base]{attributes}
\describe{
\item{\code{attr(,'cutoff')}}{
named \link[base]{double} \link[base]{vector},
the cutoff values for each predictor in \code{newX}}
}
}
}
\description{
Dichotomize one or more predictors of
a \link[survival]{Surv}, a \link[base]{logical}, or a \link[base]{double} response,
using recursive partitioning and regression tree \link[rpart]{rpart}.
}
\details{
\subsection{Dichotomize Single Predictor}{

Function \link{rpartD} dichotomizes one predictor in the following steps,

\enumerate{

\item {Recursive partitioning and regression tree \link[rpart]{rpart} analysis is
performed for the response \eqn{y} and the predictor \eqn{x}.}

\item {The \link[rpart]{labels.rpart} of the first node of
the \link[rpart]{rpart} tree
is considered as the dichotomizing rule of the \link[base]{double} predictor \eqn{x}.
The term \emph{dichotomizing rule} indicates the combination of an inequality sign
(\link[base]{>}, \link[base]{>=}, \link[base]{<} and \link[base]{<=})
and a \link[base]{double} cutoff threshold \eqn{a}}

\item {The dichotomizing rule from Step 2 is further processed, such that
\itemize{
\item {\eqn{<a} is regarded as \eqn{\geq a}}
\item {\eqn{\leq a} is regarded as \eqn{>a}}
\item {\eqn{> a} and \eqn{\geq a} are regarded as is.}
}
This step is necessary for a narrative of
\emph{greater than} or \emph{greater than or equal to}
the threshold \eqn{a}.}

\item {A \link[base]{warning} message is produced,
if the dichotomizing rule, applied to a new \link[base]{double} predictor \code{newx}, creates
an all-\code{TRUE} or all-\code{FALSE} result.
We do not make the algorithm \link[base]{stop},
as most regression models in R are capable of handling
an all-\code{TRUE} or all-\code{FALSE} predictor,
by returning a \code{NA_real_} regression coefficient estimate.
}

}
}

\subsection{Dichotomize Multiple Predictors}{

Function \link{m_rpartD} dichotomizes
each predictor \code{X[,i]} based on the response \eqn{y}
using function \link{rpartD}.
Applying the multiple dichotomizing rules to a new set of predictors \code{newX},
\itemize{
\item {A \link[base]{warning} message is produced,
if at least one of the dichotomized predictors is all-\code{TRUE} or all-\code{FALSE}.}
\item {We do not check if more than one of the dichotomized predictors
are \link[base]{identical} to each other.
We take care of this situation in helper function \link{coef_dichotom}}
}
}
}
\note{
In future \link[base]{integer} and \link[base]{factor} predictors will be supported.
}
\examples{
## Dichotomize Single Predictor
data(cu.summary, package = 'rpart') # see more details from ?rpart::cu.summary
with(cu.summary, rpartD(y = Price, x = Mileage, check_degeneracy = FALSE))
(foo = with(cu.summary, rpartD(y = Price, x = Mileage)))
foo(rnorm(10, mean = 24.5))
## Dichotomize Multiple Predictors
library(survival)
data(stagec, package = 'rpart') # see more details from ?rpart::stagec
nrow(stagec) # 146
(foo = with(stagec[1:100,], m_rpartD(y = Surv(pgtime, pgstat), X = cbind(age, g2, gleason))))
foo(as.matrix(stagec[-(1:100), c('age', 'g2', 'gleason')]))
}
\keyword{internal}
